/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.UniformResourceStorage;
import com.aptana.ide.debug.core.IActiveResourcePathGetterAdapter;
import com.aptana.ide.debug.internal.ui.UniformResourceStorageEditorInput;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.profiles.Profile;
import com.aptana.ide.editors.profiles.ProfileManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PlatformUI;

public class ActiveResourcePathGetterAdapter
implements IActiveResourcePathGetterAdapter {
    public IResource getActiveResource() {
        final IResource[] result = new IResource[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IEditorInput editorInput;
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart != null && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput) {
                    result[0] = ((IFileEditorInput)editorInput).getFile();
                }
            }
        });
        if (result[0] != null) {
            result[0] = this.findConnectedResource(result[0]);
        }
        return result[0];
    }

    public IPath getActiveResourcePath() {
        final IPath[] result = new IPath[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart != null) {
                    IEditorInput editorInput = editorPart.getEditorInput();
                    if (editorInput instanceof IFileEditorInput) {
                        result[0] = ((IFileEditorInput)editorInput).getFile().getLocation();
                    } else if (editorInput instanceof IPathEditorInput) {
                        result[0] = ((IPathEditorInput)editorInput).getPath();
                    }
                }
            }
        });
        if (result[0] != null) {
            result[0] = this.findConnectedPath(result[0]);
        }
        return result[0];
    }

    public URL getActiveResourceURL() {
        final URL[] result = new URL[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IStorage storage;
                IEditorInput editorInput;
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart != null && (editorInput = editorPart.getEditorInput()) instanceof UniformResourceStorageEditorInput && (storage = ((UniformResourceStorageEditorInput)editorInput).getStorage()) instanceof UniformResourceStorage) {
                    try {
                        result[0] = ((UniformResourceStorage)storage).getURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
                    }
                }
            }
        });
        return result[0];
    }

    private IResource findConnectedResource(IResource resource) {
        IFile file;
        IPath location = resource.getLocation();
        IPath path = this.findConnectedPath(location);
        if (path != location && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path)) != null) {
            return file;
        }
        return resource;
    }

    private IPath findConnectedPath(IPath path) {
        ProfileManager profileManager;
        Profile profile;
        String uri = path.toFile().toURI().toString();
        if (uri.startsWith("file:/") && uri.charAt(6) != '/') {
            uri = "file://" + uri.substring(6);
        }
        if ((profile = (profileManager = UnifiedEditorsPlugin.getDefault().getProfileManager()).getCurrentProfile()).containsURI(uri) >= 0 && (uri = profile.getURI()) != null && uri.length() > 0) {
            try {
                File osFile = new File(new URI(uri).getSchemeSpecificPart());
                return new Path(osFile.getCanonicalPath());
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)DebugUiPlugin.getDefault(), (String)"", (Throwable)e);
            }
        }
        return path;
    }
}

