/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui;

import com.aptana.ide.debug.internal.ui.DebugUIImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class JSDebugImageDescriptor
extends CompositeImageDescriptor {
    public static final int ENABLED = 1;
    public static final int CONDITIONAL = 2;
    public static final int ENTRY = 16;
    public static final int EXIT = 32;
    protected int flags;
    private ImageDescriptor baseImage;
    private Point size;

    public JSDebugImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.baseImage = baseImage;
        this.flags = flags;
    }

    private ImageDescriptor getBaseImage() {
        return this.baseImage;
    }

    private int getFlags() {
        return this.flags;
    }

    protected Point getSize() {
        if (this.size == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.size = new Point(data.width, data.height);
        }
        return this.size;
    }

    public boolean equals(Object object) {
        if (object instanceof JSDebugImageDescriptor) {
            JSDebugImageDescriptor other = (JSDebugImageDescriptor)((Object)object);
            return this.getBaseImage().equals(other.getBaseImage()) && this.getFlags() == other.getFlags();
        }
        return false;
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    private ImageData getImageData(String imageDescriptorKey) {
        return DebugUIImages.getImageDescriptor(imageDescriptorKey).getImageData();
    }

    private void drawOverlays() {
        this.drawBreakpointOverlays();
    }

    private void drawBreakpointOverlays() {
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((flags & 2) != 0) {
            data = (flags & 1) != 0 ? this.getImageData("IMG_OVR_CONDITIONAL_BREAKPOINT") : this.getImageData("IMG_OVR_CONDITIONAL_BREAKPOINT_DISABLED");
            this.drawImage(data, x, y);
        }
        if ((flags & 0x10) != 0) {
            x = this.getSize().x;
            y = 0;
            data = (flags & 1) != 0 ? this.getImageData("IMG_OVR_METHOD_BREAKPOINT_ENTRY") : this.getImageData("IMG_OVR_METHOD_BREAKPOINT_ENTRY_DISABLED");
            this.drawImage(data, x -= data.width, y);
        }
        if ((flags & 0x20) != 0) {
            x = this.getSize().x;
            y = this.getSize().y;
            data = (flags & 1) != 0 ? this.getImageData("IMG_OVR_METHOD_BREAKPOINT_EXIT") : this.getImageData("IMG_OVR_METHOD_BREAKPOINT_EXIT_DISABLED");
            this.drawImage(data, x -= data.width, y -= data.height);
        }
    }
}

