/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.actions;

import com.aptana.ide.debug.core.model.IJSLineBreakpoint;
import com.aptana.ide.debug.internal.ui.actions.Messages;
import com.aptana.ide.debug.internal.ui.dialogs.HitCountDialog;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BreakpointHitCountAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IInputValidator inputValidator = new IInputValidator(){

        public String isValid(String newText) {
            int value = -1;
            try {
                value = Integer.valueOf(newText.trim());
            }
            catch (NumberFormatException numberFormatException) {}
            if (value < 1) {
                return Messages.BreakpointHitCountAction_HitCountPositiveInteger;
            }
            return null;
        }
    };

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = null;
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void run(IAction action) {
        if (this.selection != null && !this.selection.isEmpty()) {
            for (IJSLineBreakpoint breakpoint : this.selection) {
                try {
                    int oldValue = breakpoint.getHitCount();
                    int newValue = this.showDialog(breakpoint);
                    if (newValue == -1) continue;
                    if (oldValue == 0 && newValue == 0) break;
                    breakpoint.setHitCount(newValue);
                }
                catch (CoreException ce) {
                    DebugUiPlugin.errorDialog(Messages.BreakpointHitCountAction_ExceptionAttemptingToSetHitCount, ce);
                }
            }
        }
    }

    private int showDialog(IJSLineBreakpoint breakpoint) {
        int currentHitCount = 0;
        try {
            currentHitCount = breakpoint.getHitCount();
        }
        catch (CoreException e) {
            DebugUiPlugin.log(e);
        }
        String initialValue = currentHitCount > 0 ? Integer.toString(currentHitCount) : "1";
        HitCountDialog dlg = new HitCountDialog(DebugUiPlugin.getActiveWorkbenchShell(), Messages.BreakpointHitCountAction_SetBreakpointHitCount, Messages.BreakpointHitCountAction_EnterNewHitCountForBreakpoint, initialValue, this.inputValidator);
        if (dlg.open() != 0) {
            return -1;
        }
        if (dlg.isHitCountEnabled()) {
            return Integer.parseInt(dlg.getValue().trim());
        }
        return 0;
    }
}

