/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.actions;

import com.aptana.ide.debug.core.model.JSInspectExpression;
import com.aptana.ide.debug.internal.ui.actions.WatchAction;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.ui.DebugUITools;

public class InspectAction
extends WatchAction
implements IWatchExpressionListener {
    protected void createExpression(String expressionText) {
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        if (context != null) {
            IWatchExpressionDelegate delegate = DebugPlugin.getDefault().getExpressionManager().newWatchExpressionDelegate(context.getModelIdentifier());
            delegate.evaluateExpression(expressionText, context, (IWatchExpressionListener)this);
        }
    }

    public void watchEvaluationFinished(final IWatchExpressionResult result) {
        if (DebugUiPlugin.getDefault() == null) {
            return;
        }
        if (result.getValue() != null || result.hasErrors()) {
            DebugUiPlugin.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    InspectAction.this.displayResult(result);
                }
            });
        }
    }

    protected void displayResult(IWatchExpressionResult result) {
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)new JSInspectExpression(result));
        this.showExpressionsView();
    }
}

