/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.actions;

import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.debug.core.model.IJSDebugTarget;
import com.aptana.ide.debug.core.model.JSDebugModel;
import com.aptana.ide.debug.internal.ui.actions.Messages;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.RunToLineHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        IEditorPart editorPart = (IEditorPart)part;
        final IEditorInput input = editorPart.getEditorInput();
        String errorMessage = null;
        if (input == null) {
            errorMessage = Messages.RunToLineAdapter_EmptyEditor;
        } else {
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = Messages.RunToLineAdapter_MissingDocument;
            } else {
                final Object[] resource = new Object[1];
                final int[] lineNumber = new int[]{-1};
                final ITextSelection textSelection = (ITextSelection)selection;
                Runnable r = new Runnable(){

                    public void run() {
                        resource[0] = (IResource)input.getAdapter(IFile.class);
                        if (resource[0] == null) {
                            resource[0] = (IUniformResource)input.getAdapter(IUniformResource.class);
                            if (resource[0] == null) {
                                return;
                            }
                        }
                        lineNumber[0] = textSelection.getStartLine() + 1;
                    }
                };
                BusyIndicator.showWhile((Display)DebugUiPlugin.getStandardDisplay(), (Runnable)r);
                if (lineNumber[0] > 0) {
                    IDebugTarget debugTarget;
                    ILineBreakpoint breakpoint = null;
                    HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
                    attributes.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
                    attributes.put("com.aptana.ide.debug.core.runToLineBreakpoint", Boolean.TRUE);
                    breakpoint = JSDebugModel.createLineBreakpointForResource((Object)resource[0], (int)lineNumber[0], attributes, (boolean)false);
                    errorMessage = Messages.RunToLineAdapter_UnableToLocateDebugTarget;
                    if (target instanceof IAdaptable && (debugTarget = (IDebugTarget)((IAdaptable)target).getAdapter(IDebugTarget.class)) != null) {
                        RunToLineHandler handler = new RunToLineHandler(debugTarget, target, (IBreakpoint)breakpoint);
                        handler.run((IProgressMonitor)new NullProgressMonitor());
                        return;
                    }
                } else {
                    errorMessage = textSelection.getLength() > 0 ? Messages.RunToLineAdapter_SelectedLineIsNotValidLocationToRunTo : Messages.RunToLineAdapter_CursorPositionIsNotValidLocationToRunTo;
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, DebugUiPlugin.getUniqueIdentifier(), 0, errorMessage, null));
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IDebugElement) {
            IDebugElement element = (IDebugElement)target;
            IJSDebugTarget adapter = (IJSDebugTarget)element.getDebugTarget().getAdapter(IJSDebugTarget.class);
            return adapter != null;
        }
        return false;
    }
}

