/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.DetailFormatter;
import com.aptana.ide.debug.core.JSDetailFormattersManager;
import com.aptana.ide.debug.internal.ui.dialogs.DetailFormatterDialog;
import com.aptana.ide.debug.internal.ui.preferences.Messages;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class JSDetailFormattersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Label listLabel;
    private Button addFormatterButton;
    private Button removeFormatterButton;
    private Button editFormatterButton;
    private Button inlineButton;
    private Button inlineAllButton;
    private CheckboxTableViewer listViewer;
    private SourceViewer sourceViewer;
    private List<String> types;
    private Set<DetailFormatter> formatters;

    public JSDetailFormattersPreferencePage() {
        this.setTitle(Messages.JSDetailFormattersPreferencePage_DetailFormatters);
        this.setPreferenceStore(DebugUiPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.JSDetailFormattersPreferencePage_OverrideDefault);
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create());
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        composite.setFont(parent.getFont());
        this.createFormattersList(composite);
        this.createOptions(composite);
        Dialog.applyDialogFont((Control)composite);
        this.noDefaultAndApplyButton();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.aptana.ide.debug.ui.js_detail_formatter_preference_page_context");
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void createOptions(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.JSDetailFormattersPreferencePage_ShowVariableDetails);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)group);
        group.setLayout((Layout)new GridLayout());
        String preference = this.getPreferenceStore().getString("com.aptana.ide.debug.ui.show_details");
        this.inlineButton = new Button((Composite)group, 16);
        this.inlineButton.setText(Messages.JSDetailFormattersPreferencePage_AsLabelForVariablesWithDetailFormatters);
        this.inlineButton.setSelection(preference.equals("INLINE_FORMATTERS"));
        this.inlineAllButton = new Button((Composite)group, 16);
        this.inlineAllButton.setText(Messages.JSDetailFormattersPreferencePage_AsLabelForAllVariables);
        this.inlineAllButton.setSelection(preference.equals("INLINE_ALL"));
        Button detailPane = new Button((Composite)group, 16);
        detailPane.setText(Messages.JSDetailFormattersPreferencePage_InDetailPaneOnly);
        detailPane.setSelection(preference.equals("DETAIL_PANE") || preference.length() == 0);
    }

    private Control createFormattersList(Composite parent) {
        Font font = parent.getFont();
        this.listLabel = new Label(parent, 0);
        this.listLabel.setText(Messages.JSDetailFormattersPreferencePage_TypesWithDetailFormatters);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.listLabel);
        this.listLabel.setFont(font);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67618);
        Table table = (Table)this.listViewer.getControl();
        GridDataFactory.fillDefaults().grab(true, true).hint(this.convertWidthInCharsToPixels(10), -1).applyTo((Control)table);
        table.setFont(font);
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DetailFormatter) {
                    return ((DetailFormatter)element).getTypeName();
                }
                return null;
            }
        });
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)composite);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.addFormatterButton = new Button(composite, 8);
        this.addFormatterButton.setText(StringUtils.ellipsify((String)Messages.JSDetailFormattersPreferencePage_Add));
        this.addFormatterButton.setToolTipText(Messages.JSDetailFormattersPreferencePage_AllowToCreateNewDetailFormatter);
        this.setButtonLayoutData(this.addFormatterButton);
        this.addFormatterButton.setFont(font);
        this.editFormatterButton = new Button(composite, 8);
        this.editFormatterButton.setText(StringUtils.ellipsify((String)Messages.JSDetailFormattersPreferencePage_Edit));
        this.editFormatterButton.setToolTipText(Messages.JSDetailFormattersPreferencePage_EditSelectedDetailFormatter);
        this.setButtonLayoutData(this.editFormatterButton);
        this.editFormatterButton.setFont(font);
        this.removeFormatterButton = new Button(composite, 8);
        this.removeFormatterButton.setText(Messages.JSDetailFormattersPreferencePage_Remove);
        this.removeFormatterButton.setToolTipText(Messages.JSDetailFormattersPreferencePage_RemoveAllSelectedDetailFormatters);
        this.setButtonLayoutData(this.removeFormatterButton);
        this.removeFormatterButton.setFont(font);
        Label label = new Label(parent, 0);
        label.setText(Messages.JSDetailFormattersPreferencePage_DetailFormatterCodeSnippetDefinedForSelectedType);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)label);
        label.setFont(font);
        this.sourceViewer = new SourceViewer(parent, null, 2816);
        this.sourceViewer.getTextWidget().setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.sourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(this.sourceViewer.getControl());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JSDetailFormattersPreferencePage.this.updatePage((IStructuredSelection)event.getSelection());
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    JSDetailFormattersPreferencePage.this.editType();
                }
            }
        });
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((DetailFormatter)event.getElement()).setEnabled(event.getChecked());
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    JSDetailFormattersPreferencePage.this.removeTypes();
                }
            }
        });
        this.addFormatterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JSDetailFormattersPreferencePage.this.addType();
            }
        });
        this.editFormatterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JSDetailFormattersPreferencePage.this.editType();
            }
        });
        this.removeFormatterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JSDetailFormattersPreferencePage.this.removeTypes();
            }
        });
        this.editFormatterButton.setEnabled(false);
        this.removeFormatterButton.setEnabled(false);
        this.sourceViewer.setEditable(false);
        this.sourceViewer.setDocument((IDocument)new Document());
        this.loadDetailFormatters();
        this.listViewer.setInput(this.formatters);
        this.updateViewerCheckboxes();
        return parent;
    }

    private void updatePage(IStructuredSelection selection) {
        this.removeFormatterButton.setEnabled(!selection.isEmpty());
        this.editFormatterButton.setEnabled(selection.size() == 1);
        this.sourceViewer.getDocument().set(selection.size() == 1 ? ((DetailFormatter)selection.getFirstElement()).getSnippet() : "");
    }

    private void addType() {
        DetailFormatter detailFormatfer = new DetailFormatter("", "", true);
        DetailFormatterDialog dlg = new DetailFormatterDialog(this.getShell(), detailFormatfer, this.types, false);
        if (dlg.open() == 0) {
            this.addDetailFormatter(detailFormatfer);
        }
    }

    private void removeTypes() {
        Object[] list = this.formatters.toArray();
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        Object first = selection.getFirstElement();
        int index = -1;
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(first)) {
                index = i;
                break;
            }
            ++i;
        }
        this.removeDetailFormatters(selection.toArray());
        list = this.formatters.toArray();
        if (index > list.length - 1) {
            index = list.length - 1;
        }
        if (index >= 0) {
            this.listViewer.setSelection((ISelection)new StructuredSelection(list[index]));
        }
    }

    private void editType() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        DetailFormatterDialog dlg = new DetailFormatterDialog(this.getShell(), (DetailFormatter)selection.getFirstElement(), null, true, true);
        if (dlg.open() == 0) {
            this.listViewer.refresh();
            this.updateViewerCheckboxes();
            this.updatePage(selection);
        }
    }

    public boolean performOk() {
        JSDetailFormattersManager.getDefault().setDetailFormatters(this.formatters);
        String value = "DETAIL_PANE";
        if (this.inlineAllButton.getSelection()) {
            value = "INLINE_ALL";
        } else if (this.inlineButton.getSelection()) {
            value = "INLINE_FORMATTERS";
        }
        this.getPreferenceStore().setValue("com.aptana.ide.debug.ui.show_details", value);
        DebugUiPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void updateViewerCheckboxes() {
        DetailFormatter[] checkedElementsTmp = new DetailFormatter[this.formatters.size()];
        int i = 0;
        for (DetailFormatter detailFormatter : this.formatters) {
            if (!detailFormatter.isEnabled()) continue;
            checkedElementsTmp[i++] = detailFormatter;
        }
        Object[] checkedElements = new DetailFormatter[i];
        System.arraycopy(checkedElementsTmp, 0, checkedElements, 0, i);
        this.listViewer.setAllChecked(false);
        this.listViewer.setCheckedElements(checkedElements);
    }

    private void addDetailFormatter(DetailFormatter detailFormatter) {
        this.formatters.add(detailFormatter);
        this.types.add(detailFormatter.getTypeName());
        this.listViewer.refresh();
        this.updateViewerCheckboxes();
        StructuredSelection selection = new StructuredSelection((Object)detailFormatter);
        this.listViewer.setSelection((ISelection)selection);
        this.updatePage((IStructuredSelection)selection);
    }

    private void removeDetailFormatters(Object[] detailFormatters) {
        int i = 0;
        while (i < detailFormatters.length) {
            this.formatters.remove(detailFormatters[i]);
            this.types.remove(((DetailFormatter)detailFormatters[i]).getTypeName());
            ++i;
        }
        this.listViewer.refresh();
        this.listViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.updatePage((IStructuredSelection)StructuredSelection.EMPTY);
    }

    private void loadDetailFormatters() {
        this.formatters = new TreeSet<DetailFormatter>();
        Collection detailFormatters = JSDetailFormattersManager.getDefault().getDetailFormatters();
        this.types = new ArrayList<String>(detailFormatters.size());
        for (DetailFormatter detailFormatter : detailFormatters) {
            this.formatters.add(detailFormatter);
            this.types.add(detailFormatter.getTypeName());
        }
    }
}

