/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.search.Activator;
import com.aptana.ide.search.AptanaExtraDecorator;
import com.aptana.ide.search.DecoratingFileSearchLabelProvider;
import com.aptana.ide.search.FileTreeContentProvider;
import com.aptana.ide.search.MatchesContentProvider;
import com.aptana.ide.search.Messages;
import com.aptana.ide.search.epl.AptanaFileMatch;
import com.aptana.ide.search.epl.Compatibility;
import com.aptana.ide.search.epl.ReplaceAction2;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.util.PixelConverter;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.search2.internal.ui.basic.views.SetLayoutAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.IPageSite;

public class AptanaFileSearchPage
extends FileSearchPage {
    static Method superMethod;
    static final Object[] NO_ELEMENTS;
    static final Match[] NO_MATCH;
    private static final int LAYOUT_MATCHES = 4;
    ITreeContentProvider provider;
    boolean turnOff;
    public static final int SHOW_LABEL = 1;
    public static final int SHOW_LABEL_PATH = 2;
    public static final int SHOW_PATH_LABEL = 3;
    private int fOrder = 2;
    private SetLayoutAction fFlatAction = new SetLayoutAction((AbstractTextSearchViewPage)this, Messages.AptanaFileSearchPage_ShowMatches, Messages.AptanaFileSearchPage_ShowMatchesTooltip, 4);
    int layout;
    private static final String KEY_LAYOUT = "org.eclipse.search.resultpage.layout";
    private static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private MatchesContentProvider structuredContentProvider;
    private Listener listener;
    private Listener listener1;
    private PixelConverter metrics;
    private DecoratingFileSearchLabelProvider baseLabelProvider;

    static {
        try {
            superMethod = AbstractTextSearchViewPage.class.getMethod("getElementLimit", new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        NO_ELEMENTS = new Object[0];
        NO_MATCH = new Match[0];
    }

    public Integer getElementLimit1() {
        if (superMethod != null) {
            try {
                return (Integer)superMethod.invoke((Object)this, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (Compatibility.isTableLimited()) {
            return new Integer(Compatibility.getTableLimit());
        }
        return new Integer(-1);
    }

    protected void evaluateChangedElements(Match[] matches, Set changedElements) {
        int i = 0;
        while (i < matches.length) {
            changedElements.add(matches[i].getElement());
            ++i;
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        int indexOf;
        IContributionItem[] items;
        Separator find;
        try {
            super.fillContextMenu(mgr);
            find = (Separator)mgr.find("group.reorganize");
            items = find.getParent().getItems();
            indexOf = Arrays.asList(items).indexOf(find);
            mgr.remove(items[indexOf + 1]);
            mgr.remove(items[indexOf + 2]);
            this.doAdd(mgr);
        }
        catch (ClassCastException classCastException) {
            this.doAdd(mgr);
        }
        if (this.layout == 4) {
            find = (Separator)mgr.find("group.viewerSetup");
            items = find.getParent().getItems();
            indexOf = Arrays.asList(items).indexOf(find);
            MenuManager contributionItem = (MenuManager)items[indexOf + 1];
            IContributionItem[] items2 = contributionItem.getItems();
            ActionContributionItem it0 = (ActionContributionItem)items2[0];
            ActionContributionItem it1 = (ActionContributionItem)items2[1];
            it0.getAction().setChecked(this.fOrder == 2);
            it1.getAction().setChecked(this.fOrder == 3);
        }
    }

    private void doAdd(IMenuManager mgr) {
        ReplaceAction2 replaceAll;
        ReplaceAction2 replaceAction = new ReplaceAction2((FileSearchPage)this, (IStructuredSelection)this.getViewer().getSelection());
        if (replaceAction.isEnabled()) {
            mgr.appendToGroup("group.reorganize", (IAction)replaceAction);
        }
        if ((replaceAll = new ReplaceAction2((FileSearchPage)this)).isEnabled()) {
            mgr.appendToGroup("group.reorganize", (IAction)replaceAll);
        }
    }

    public String getLabel() {
        AbstractTextSearchResult input = this.getInput();
        if (this.layout == 4) {
            int matchCount;
            if (input == null) {
                return "";
            }
            String label = input.getLabel();
            TableViewer viewer = (TableViewer)this.getViewer();
            int itemCount = viewer.getTable().getItemCount();
            if (itemCount < (matchCount = this.getInput().getMatchCount())) {
                return org.eclipse.search.internal.ui.Messages.format((String)Messages.AptanaFileSearchPage_NOT_ALL_MATCHES, (Object[])new Object[]{label, new Integer(itemCount), new Integer(matchCount)});
            }
        }
        return super.getLabel();
    }

    public void init(IPageSite site) {
        super.init(site);
        site.getActionBars().getMenuManager().appendToGroup("group.viewerSetup", (IAction)this.fFlatAction);
    }

    public AptanaFileSearchPage() {
        this.fFlatAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.aptana.ide.search", (String)"/icons/verticalOrientation.gif"));
    }

    public void setSortOrder(int sortOrder) {
        if (this.layout == 4) {
            this.fOrder = sortOrder;
            this.getSettings().put(KEY_SORTING, sortOrder);
            this.getViewer().refresh();
            return;
        }
        super.setSortOrder(sortOrder);
    }

    public void restoreState(IMemento memento) {
        Integer value;
        Integer l;
        try {
            this.layout = this.getSettings().getInt(KEY_LAYOUT);
        }
        catch (NumberFormatException numberFormatException) {
            this.layout = 2;
        }
        if (this.layout == 4) {
            this.getSettings().put(KEY_LAYOUT, 1);
        }
        if (memento != null && (l = memento.getInteger(KEY_LAYOUT)) != null) {
            this.layout = l;
            if (this.layout == 4) {
                memento.putInteger(KEY_LAYOUT, 1);
            }
        }
        super.restoreState(memento);
        try {
            this.fOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {
            this.fOrder = 2;
        }
        if (memento != null && (value = memento.getInteger(KEY_SORTING)) != null) {
            this.fOrder = value;
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.layout == 4) {
            this.layout = 1;
            this.setLayout(4);
        }
    }

    public void saveState(IMemento memento) {
        memento.putInteger(KEY_LAYOUT, this.layout);
    }

    public void setLayout(int layout) {
        if (this.layout == layout) {
            return;
        }
        if (layout == 4) {
            this.getControl().setRedraw(false);
            if (this.getLayout() != 1) {
                super.setLayout(1);
            }
            this.layout = layout;
            this.reconfigureTableViewer();
            this.getControl().setRedraw(true);
            ((Composite)this.getControl()).layout(true, true);
            this.getControl().redraw();
            Separator find = (Separator)this.getSite().getActionBars().getMenuManager().find("group.viewerSetup");
            IContributionItem[] items = find.getParent().getItems();
            int indexOf = Arrays.asList(items).indexOf(find);
            SubContributionItem contributionItem = (SubContributionItem)items[indexOf + 1];
            ActionContributionItem ac = (ActionContributionItem)contributionItem.getInnerItem();
            ac.getAction().setChecked(false);
            contributionItem = (SubContributionItem)items[indexOf + 3];
            ac = (ActionContributionItem)contributionItem.getInnerItem();
            ac.getAction().setChecked(true);
            find.update();
            this.getSettings().put(KEY_LAYOUT, layout);
        } else {
            if (this.layout == 4) {
                this.layout = layout;
                if (layout == 1) {
                    this.getControl().setRedraw(false);
                    super.setLayout(2);
                    super.setLayout(1);
                    ((Composite)this.getControl()).layout(true, true);
                    this.getControl().setRedraw(true);
                    return;
                }
            }
            this.layout = layout;
            super.setLayout(layout);
        }
    }

    public Match getCurrentMatch() {
        if (this.layout == 4) {
            StackTraceElement[] stackTrace = new Exception().getStackTrace();
            String methodName = stackTrace[1].getMethodName();
            if (methodName.equals("gotoNextMatch")) {
                return null;
            }
            if (methodName.equals("gotoPreviousMatch")) {
                return null;
            }
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            Object element = selection.getFirstElement();
            return (Match)element;
        }
        return super.getCurrentMatch();
    }

    public void internalRemoveSelected() {
        if (this.layout != 4) {
            super.internalRemoveSelected();
        } else {
            TableViewer cc = (TableViewer)this.getViewer();
            StructuredSelection ss = (StructuredSelection)cc.getSelection();
            List list = ss.toList();
            Match[] ms = new Match[list.size()];
            list.toArray(ms);
            this.getInput().removeMatches(ms);
            this.getViewPart().updateLabel();
        }
    }

    protected void handleSearchResultChanged(SearchResultEvent e) {
        if (this.layout != 4) {
            super.handleSearchResultChanged(e);
            return;
        }
        if (e instanceof MatchEvent) {
            MatchEvent me = (MatchEvent)e;
            int kind = me.getKind();
            if (Display.getCurrent() != null && kind == 2) {
                TableViewer cc = (TableViewer)this.getViewer();
                Table table = cc.getTable();
                int selectionIndex = table.getSelectionIndex();
                cc.refresh();
                if (selectionIndex != -1 && selectionIndex < table.getItemCount()) {
                    TableItem item = cc.getTable().getItem(selectionIndex);
                    cc.setSelection((ISelection)new StructuredSelection(item.getData()));
                }
            } else {
                super.handleSearchResultChanged(e);
            }
        } else if (e instanceof RemoveAllEvent) {
            super.handleSearchResultChanged(e);
        }
    }

    private void reconfigureTableViewer() {
        TableViewer tViewer = (TableViewer)this.getViewer();
        TableColumn[] columns = tViewer.getTable().getColumns();
        int a = 0;
        while (a < columns.length) {
            columns[a].dispose();
            ++a;
        }
        this.metrics = new PixelConverter(tViewer.getControl());
        tViewer.getTable().setHeaderVisible(true);
        TableColumn clmn = new TableColumn(tViewer.getTable(), 16384);
        clmn.setText(Messages.AptanaFileSearchPage_File);
        TableColumn clmn1 = new TableColumn(tViewer.getTable(), 16384);
        clmn1.setText(Messages.AptanaFileSearchPage_Line);
        TableColumn clmn2 = new TableColumn(tViewer.getTable(), 16384);
        clmn2.setText(Messages.AptanaFileSearchPage_Source);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(50));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        PreferenceUtils.persist((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (Table)tViewer.getTable(), (String)"tviewer");
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                AptanaFileMatch aptanaFileMatch;
                if (event.index == 2 && (aptanaFileMatch = (AptanaFileMatch)event.item.getData()) != null) {
                    event.gc.drawText(aptanaFileMatch.getLineContent(), event.x, event.y);
                }
            }
        };
        this.listener1 = new Listener(){

            public void handleEvent(Event event) {
                AptanaFileMatch aptanaFileMatch;
                if (event.index == 2 && (aptanaFileMatch = (AptanaFileMatch)event.item.getData()) != null) {
                    event.width = AptanaFileSearchPage.this.metrics.convertWidthInCharsToPixels(aptanaFileMatch.getLineContent().length());
                }
            }
        };
        tViewer.getTable().addListener(42, this.listener);
        tViewer.getTable().setLayout((Layout)tableLayout);
        Object labelProvider = tViewer.getLabelProvider();
        labelProvider = new DecoratingFileSearchLabelProvider(new FileLabelProvider((AbstractTextSearchViewPage)this, 2));
        tViewer.setLabelProvider(labelProvider);
        this.baseLabelProvider = (DecoratingFileSearchLabelProvider)((Object)labelProvider);
        tViewer.setInput(null);
        tViewer.setLabelProvider((IBaseLabelProvider)new MatchesTableLabelProvider());
        IContentProvider contentProvider = tViewer.getContentProvider();
        this.structuredContentProvider = new MatchesContentProvider(this, contentProvider);
        tViewer.setContentProvider((IContentProvider)this.structuredContentProvider);
        tViewer.setInput((Object)this.getInput());
        tViewer.getTable().getParent().layout(true);
    }

    protected void clear() {
        StructuredViewer viewer = this.getViewer();
        if (this.layout == 4) {
            viewer.getControl().setRedraw(false);
            viewer.getControl().removeListener(42, this.listener);
            viewer.getControl().removeListener(41, this.listener1);
            super.clear();
            viewer.getControl().setRedraw(true);
            viewer.getControl().addListener(42, this.listener);
            viewer.getControl().addListener(41, this.listener1);
        } else {
            super.clear();
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.layout != 4) {
            super.elementsChanged(objects);
        } else {
            this.structuredContentProvider.elementsChanged(objects);
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        super.configureTreeViewer(viewer);
        FileTreeContentProvider provider2 = new FileTreeContentProvider(this, (AbstractTreeViewer)viewer){};
        viewer.setContentProvider((IContentProvider)provider2);
        try {
            Field field = FileSearchPage.class.getDeclaredField("fContentProvider");
            field.setAccessible(true);
            field.set((Object)this, provider2);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Error during conifguration using reflection", (Throwable)e);
        }
        final DecoratingFileSearchLabelProvider labelProvider = new DecoratingFileSearchLabelProvider(new FileLabelProvider((AbstractTextSearchViewPage)this, 2));
        DecoratingLabelProvider decoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)labelProvider, new AptanaExtraDecorator(this)){

            public void setLabelDecorator(ILabelDecorator decorator) {
                if (decorator != null) {
                    AptanaFileSearchPage.this.turnOff = true;
                }
                labelProvider.setLabelDecorator(decorator);
                AptanaFileSearchPage.this.turnOff = false;
            }

            public void dispose() {
            }
        };
        viewer.setInput((Object)this.getInput());
        this.provider = (ITreeContentProvider)viewer.getContentProvider();
        viewer.setLabelProvider((IBaseLabelProvider)decoratingLabelProvider);
    }

    private final class MatchesTableLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private WorkbenchLabelProvider fLabelProvider = new WorkbenchLabelProvider();
        private String[] fArgs = new String[2];
        private static final String fgSeparatorFormat = "{0} - {1}";

        private MatchesTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.fLabelProvider.getImage(((Match)element).getElement());
            }
            return null;
        }

        public String getText(IResource resource) {
            String text;
            if (!resource.exists()) {
                text = SearchMessages.FileLabelProvider_removed_resource_label;
            } else {
                IPath path = resource.getFullPath().removeLastSegments(1);
                if (path.getDevice() == null) {
                    path = path.makeRelative();
                }
                if (AptanaFileSearchPage.this.fOrder == 1 || AptanaFileSearchPage.this.fOrder == 2) {
                    text = this.fLabelProvider.getText((Object)resource);
                    if (path != null && AptanaFileSearchPage.this.fOrder == 2) {
                        this.fArgs[0] = text;
                        this.fArgs[1] = path.toString();
                        text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                    }
                } else {
                    text = path != null ? path.toString() : "";
                    if (AptanaFileSearchPage.this.fOrder == 3) {
                        this.fArgs[0] = text;
                        this.fArgs[1] = this.fLabelProvider.getText((Object)resource);
                        text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                    }
                }
            }
            return text;
        }

        public String getColumnText(Object element, int columnIndex) {
            AptanaFileMatch match = (AptanaFileMatch)element;
            if (columnIndex == 0) {
                return this.getText((IResource)match.getFile());
            }
            if (columnIndex == 1) {
                return Integer.toString(match.getLineNumber());
            }
            if (columnIndex == 2) {
                return "";
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
            AptanaFileSearchPage.this.baseLabelProvider.addListener(listener);
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return AptanaFileSearchPage.this.baseLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            AptanaFileSearchPage.this.baseLabelProvider.removeListener(listener);
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            StringBuilder bld = new StringBuilder();
            bld.append(this.getColumnText(element, 0));
            bld.append('\t');
            bld.append(this.getColumnText(element, 1));
            bld.append('\t');
            bld.append(((AptanaFileMatch)element).getLineContent());
            return bld.toString();
        }
    }
}

