/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.search.epl.AptanaFileMatch;
import com.aptana.ide.search.epl.AptanaFileSystemMatch;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public final class Utils {
    private Utils() {
    }

    public static IEditorPart openMatch(AptanaFileMatch mm) {
        try {
            IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)mm.getFile());
            if (openEditor instanceof ITextEditor) {
                ITextEditor te = (ITextEditor)openEditor;
                te.selectAndReveal(mm.getOffset(), mm.getLength());
            }
            return openEditor;
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SearchMessages.DefaultSearchViewPage_show_match, (String)SearchMessages.DefaultSearchViewPage_error_no_editor, (IStatus)e.getStatus());
            return null;
        }
    }

    public static IEditorPart openMatch(AptanaFileSystemMatch mm) {
        try {
            IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)CoreUIUtils.createJavaFileEditorInput((File)mm.getFile()), (String)IDE.getEditorDescriptor((String)mm.getFile().getName()).getId());
            if (openEditor instanceof ITextEditor) {
                ITextEditor te = (ITextEditor)openEditor;
                te.selectAndReveal(mm.getOffset(), mm.getLength());
            }
            return openEditor;
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SearchMessages.DefaultSearchViewPage_show_match, (String)SearchMessages.DefaultSearchViewPage_error_no_editor, (IStatus)e.getStatus());
            return null;
        }
    }
}

