/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ssh.impl;

import com.aptana.ide.ssh.Activator;
import com.aptana.ide.ssh.impl.CommandLauncher;
import com.aptana.ide.ssh.impl.Utilities;
import com.aptana.ide.ssh.impl.preferences.SSHPreferences;
import com.aptana.ide.ssh.spi.ISSHLauncher;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHLauncher
implements ISSHLauncher {
    @Override
    public void launchSSH(String host) {
        this.launchSSH(host, System.getProperty("user.name"));
    }

    @Override
    public void launchSSH(String host, String user) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("host", host);
        parameters.put("user", user);
        this.launchSSH(parameters);
    }

    @Override
    public void launchSSH(Map<String, String> parameters) {
        String puttyDotExe;
        String terminalDotApp;
        String userAtHost = parameters.get("user@host");
        if (userAtHost == null) {
            parameters.put("user@host", String.valueOf(parameters.get("user")) + "@" + parameters.get("host"));
        }
        if ("macosx".equals(Platform.getOS()) && (terminalDotApp = parameters.get("terminal.scpt")) == null) {
            parameters.put("terminal.scpt", Activator.getDefault().getTerminalDotScpt());
        }
        if ("win32".equals(Platform.getOS()) && (puttyDotExe = parameters.get("putty.exe")) == null) {
            puttyDotExe = Activator.getDefault().getPuttyDotExe();
            if (puttyDotExe == null) {
                puttyDotExe = "putty.exe";
            }
            parameters.put("putty.exe", puttyDotExe);
        }
        CommandLauncher.launch(Utilities.formatCommand(SSHPreferences.getSSHCommand(), parameters));
    }
}

