/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.io;

import com.aptana.ide.io.Messages;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class TabledOutputStream
implements DataOutput {
    private OutputStream _outputStream;
    private ByteArrayOutputStream _buffer;
    private DataOutputStream _internalStream;
    private StringBuffer _strings;
    private List<Integer> _offsets;
    private int _offset;
    private List<Integer> _ints;

    public TabledOutputStream(OutputStream output) {
        if (output == null) {
            throw new IllegalArgumentException(Messages.TabledOutputStream_Output_Undefined);
        }
        this._outputStream = output;
        this._buffer = new ByteArrayOutputStream();
        this._internalStream = new DataOutputStream(this._buffer);
        this._strings = new StringBuffer();
        this._offsets = new ArrayList<Integer>();
        this._offset = 0;
        this._ints = new ArrayList<Integer>();
    }

    public void close() {
        try {
            this._internalStream.close();
            DataOutputStream out = new DataOutputStream(this._outputStream);
            out.writeByte(1);
            out.writeByte(0);
            out.writeInt(this._offsets.size());
            int i = 0;
            while (i < this._offsets.size()) {
                int value = this._offsets.get(i);
                out.writeInt(value);
                ++i;
            }
            byte[] stringData = this._strings.toString().getBytes("utf-8");
            out.writeInt(stringData.length);
            out.write(stringData);
            out.writeInt(this._ints.size());
            int i2 = 0;
            while (i2 < this._ints.size()) {
                int value = this._ints.get(i2);
                out.writeInt(value);
                ++i2;
            }
            out.write(this._buffer.toByteArray());
            out.close();
        }
        catch (IOException iOException) {}
    }

    public void writeDouble(double v) throws IOException {
        this._internalStream.writeDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this._internalStream.writeFloat(v);
    }

    public void write(int b) throws IOException {
        this._internalStream.write(b);
    }

    public void writeByte(int v) throws IOException {
        this._internalStream.writeByte(v);
    }

    public void writeChar(int v) throws IOException {
        this._internalStream.writeChar(v);
    }

    public void writeInt(int v) throws IOException {
        this._ints.add(new Integer(v));
    }

    public void writeShort(int v) throws IOException {
        this._internalStream.writeShort(v);
    }

    public void writeLong(long v) throws IOException {
        this._internalStream.writeLong(v);
    }

    public void writeBoolean(boolean v) throws IOException {
        this._internalStream.writeBoolean(v);
    }

    public void write(byte[] b) throws IOException {
        this._internalStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._internalStream.write(b, off, len);
    }

    public void writeBytes(String s) throws IOException {
        this._internalStream.writeBytes(s);
    }

    public void writeChars(String s) throws IOException {
        this._internalStream.writeChars(s);
    }

    public void writeUTF(String str) throws IOException {
        if (str == null) {
            str = "";
        }
        this._strings.append(str);
        this._offsets.add(new Integer(this._offset));
        this._offset += str.length();
    }
}

