/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer;

import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.Offset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lexeme
implements Cloneable,
Comparable<Offset>,
IRange {
    private static final int AFTER_EOL = 1;
    private static final int HIGHLIGHTED = 2;
    private IToken _token;
    private String _text;
    private int _flags;
    public int offset;
    public int typeIndex;
    public int length;

    public Lexeme(IToken token, String text, int offset) {
        this._token = token;
        this._text = text;
        this.offset = offset;
        this.typeIndex = token.getTypeIndex();
        this.length = text.length();
    }

    public void adjustOffset(int delta) {
        this.offset += delta;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public int compareTo(Offset o) {
        int offset = o.offset;
        int result = 0;
        if (offset < this.offset) {
            result = 1;
        } else if (this.offset + this.length <= offset) {
            result = -1;
        }
        return result;
    }

    @Override
    public boolean containsOffset(int offset) {
        return this.offset <= offset && offset < this.offset + this.length;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof Lexeme) {
            Lexeme that = (Lexeme)obj;
            result = this._text.equals(that._text) && this._token == that._token;
        }
        return result;
    }

    public String getCategory() {
        return this._token.getCategory();
    }

    public int getCategoryIndex() {
        return this._token.getCategoryIndex();
    }

    @Override
    public int getEndingOffset() {
        return this.offset + this.length;
    }

    public String getLanguage() {
        return this._token.getLanguage();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getStartingOffset() {
        return this.offset;
    }

    public String getText() {
        return this._text;
    }

    public IToken getToken() {
        return this._token;
    }

    public String getType() {
        return this._token.getType();
    }

    public boolean isAfterEOL() {
        return (this._flags & 1) == 1;
    }

    @Override
    public boolean isEmpty() {
        return this.length <= 0;
    }

    public boolean isHighlighted() {
        return (this._flags & 2) == 2;
    }

    public boolean isOverlapping(Lexeme lexeme) {
        int startingOffset1 = this.offset;
        int startingOffset2 = lexeme.offset;
        int endingOffset1 = this.getEndingOffset() - 1;
        int endingOffset2 = lexeme.getEndingOffset() - 1;
        return startingOffset2 <= startingOffset1 && startingOffset1 <= endingOffset2 || startingOffset2 <= endingOffset1 && endingOffset1 <= endingOffset2 || startingOffset1 <= startingOffset2 && startingOffset2 <= endingOffset1 || startingOffset1 <= endingOffset2 && endingOffset2 <= endingOffset1;
    }

    public void setAfterEOL() {
        this._flags |= 1;
    }

    public void setHighlighted(boolean value) {
        this._flags = value ? (this._flags |= 2) : (this._flags &= 0xFFFFFFFD);
    }

    public void setToken(IToken token) {
        this._token = token;
        this.typeIndex = token.getTypeIndex();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String className = this.getCategory();
        String name = this.getType();
        sb.append("[").append(this.getLanguage()).append("] ");
        if (!className.equals("default")) {
            sb.append(className).append(".");
        }
        sb.append(name);
        sb.append("@").append(this.offset).append("-").append(this.getEndingOffset());
        sb.append(": ~").append(this._text).append("~");
        return sb.toString();
    }

    public void setText(String text) {
        this._text = text;
    }
}

