/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer;

import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.ITokenList;

public class Token
implements IToken {
    public static String defaultTokenCategory = "NO_CATEGORY";
    public static String defaultLexerGroup = "default";
    private ITokenList _owningTokenList;
    private int _index;
    private int _categoryIndex;
    private int _typeIndex;
    private int _lexerGroupIndex;
    private int _newLexerGroupIndex;
    private String _category;
    private String _type;
    private String _lexerGroup;
    private String _newLexerGroup;
    private String _language;
    private String _displayName;
    private boolean _sealed;

    public Token(ITokenList owningTokenList) {
        this._owningTokenList = owningTokenList;
        if (owningTokenList != null) {
            this._language = owningTokenList.getLanguage();
        }
    }

    public String getCategory() {
        String result = this._category;
        if (result == null || result.length() == 0) {
            result = defaultTokenCategory;
        }
        return result;
    }

    public void setCategory(String categoryName) {
        if (!this._sealed) {
            this._category = categoryName;
        }
    }

    public int getCategoryIndex() {
        return this._categoryIndex;
    }

    public void setCategoryIndex(int value) {
        if (!this._sealed) {
            this._categoryIndex = value;
        }
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int index) {
        if (!this._sealed) {
            this._index = index;
        }
    }

    public String getLanguage() {
        return this._language;
    }

    public String getLexerGroup() {
        String result = this._lexerGroup;
        if (result == null || result.length() == 0) {
            result = defaultLexerGroup;
        }
        return result;
    }

    public void setLexerGroup(String lexerGroupName) {
        if (!this._sealed) {
            this._lexerGroup = lexerGroupName;
        }
    }

    public int getLexerGroupIndex() {
        return this._lexerGroupIndex;
    }

    public void setLexerGroupIndex(int value) {
        if (!this._sealed) {
            this._lexerGroupIndex = value;
        }
    }

    public String getNewLexerGroup() {
        String result = this._newLexerGroup;
        if (result == null || result.length() == 0) {
            result = this.getLexerGroup();
        }
        return result;
    }

    public void setNewLexerGroup(String newLexerGroupName) {
        if (!this._sealed) {
            this._newLexerGroup = newLexerGroupName;
        }
    }

    public int getNewLexerGroupIndex() {
        return this._newLexerGroupIndex;
    }

    public void setNewLexerGroupIndex(int value) {
        if (!this._sealed) {
            this._newLexerGroupIndex = value;
        }
    }

    public ITokenList getOwningTokenList() {
        return this._owningTokenList;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String typeName) {
        if (!this._sealed) {
            this._type = typeName;
        }
    }

    public int getTypeIndex() {
        return this._typeIndex;
    }

    public void setTypeIndex(int value) {
        if (!this._sealed) {
            this._typeIndex = value;
        }
    }

    public boolean isSealed() {
        return this._sealed;
    }

    public void seal() {
        this._sealed = true;
    }

    public String getDisplayName() {
        if (this._displayName == null && this._type != null) {
            String name = this._type.toLowerCase();
            StringBuffer sb = new StringBuffer("");
            boolean toUpper = true;
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                if (c == '_') {
                    toUpper = true;
                    sb.append(' ');
                } else if (toUpper) {
                    sb.append(Character.toUpperCase(c));
                    toUpper = false;
                } else {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        if (!this._sealed && displayName != null) {
            this._displayName = displayName;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(").append(this._lexerGroup).append(")");
        sb.append("[").append(this._language).append("]");
        sb.append(this._category).append(":").append(this._type);
        return sb.toString();
    }
}

