/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.AbstractCharacterMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.Messages;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CharacterClassMatcher
extends AbstractCharacterMatcher {
    private Set<Character> _characters;

    public CharacterClassMatcher() {
    }

    public CharacterClassMatcher(String characters) {
        this(characters.toCharArray());
    }

    public CharacterClassMatcher(char[] characters) {
        this.addCharacters(characters);
    }

    public void addCharacter(char character) {
        if (this._characters == null) {
            this._characters = new HashSet<Character>();
        }
        this._characters.add(Character.valueOf(character));
    }

    public void addCharacters(char[] characters) {
        int i = 0;
        while (i < characters.length) {
            int c = characters[i];
            if (c == 92 && i < characters.length - 1) {
                int c2 = characters[++i];
                switch (c2) {
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 118: {
                        c = 11;
                        break;
                    }
                    default: {
                        c = c2;
                    }
                }
            }
            this.addCharacter((char)c);
            ++i;
        }
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        if (this._characters != null) {
            for (char c : this._characters) {
                if (this.getNegate()) {
                    map.addNegatedCharacterMatcher(c, target);
                    continue;
                }
                map.addCharacterMatcher(c, target);
            }
        }
    }

    public void appendText(String text) {
        super.appendText(text);
        this.addCharacters(text.toCharArray());
    }

    public char[] getCharacters() {
        char[] result = new char[]{};
        if (this._characters != null) {
            result = new char[this._characters.size()];
            Iterator<Character> characters = this._characters.iterator();
            int i = 0;
            while (characters.hasNext()) {
                result[i++] = characters.next().charValue();
            }
        }
        return result;
    }

    protected boolean matchCharacter(char c) {
        boolean result = false;
        if (this._characters != null) {
            result = this._characters.contains(Character.valueOf(c));
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        char[] chars = this.getCharacters();
        Arrays.sort(chars);
        buffer.append(chars);
        buffer.append("]");
        return buffer.toString();
    }

    protected void validateLocal() {
        super.validateLocal();
        if (this._characters == null || this._characters.size() == 0) {
            this.getDocument().sendError(Messages.CharacterClassMatcher_No_Text_Content, this);
        }
    }
}

