/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.AbstractCharacterMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.Messages;
import com.aptana.ide.lexer.matcher.model.UseElement;

public class CharacterMatcher
extends AbstractCharacterMatcher {
    private char _character;
    private boolean _characterDefined;

    public CharacterMatcher() {
    }

    public CharacterMatcher(char c) {
        this._character = c;
    }

    public void addChildTypes() {
        this.addChildType(UseElement.class);
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        if (this.getChildCount() > 0) {
            map.addUncategorizedMatcher(target);
        } else if (this.getNegate()) {
            map.addNegatedCharacterMatcher(this._character, target);
        } else {
            map.addCharacterMatcher(this._character, target);
        }
    }

    public void appendText(String text) {
        super.appendText(text);
        if (text != null && text.length() > 0) {
            int c = text.charAt(0);
            if (c == 92 && text.length() > 1) {
                char c2 = text.charAt(1);
                switch (c2) {
                    case 'f': {
                        c = 12;
                        break;
                    }
                    case 'n': {
                        c = 10;
                        break;
                    }
                    case 'r': {
                        c = 13;
                        break;
                    }
                    case 't': {
                        c = 9;
                        break;
                    }
                    case 'v': {
                        c = 11;
                        break;
                    }
                    default: {
                        c = c2;
                    }
                }
                this._character = (char)c;
            } else {
                this._character = c;
            }
            this._characterDefined = true;
        }
    }

    public char getCharacter() {
        UseElement use;
        String text;
        char result = this.getChildCount() > 0 ? ((text = (use = (UseElement)this.getChild(0)).getText()).length() > 0 ? text.charAt(0) : (char)'\u0000') : this._character;
        return result;
    }

    protected boolean matchCharacter(char c) {
        return c == this.getCharacter();
    }

    public String toString() {
        String result;
        switch (this._character) {
            case '\r': {
                result = "\r";
                break;
            }
            case '\n': {
                result = "\n";
                break;
            }
            case '\t': {
                result = "\t";
                break;
            }
            default: {
                result = Character.toString(this._character);
            }
        }
        return result;
    }

    protected void validateLocal() {
        super.validateLocal();
        if (!this._characterDefined && this.getChildCount() == 0) {
            this.getDocument().sendError(Messages.CharacterMatcher_No_Text_Or_Use_Element, this);
        } else if (this.getChildCount() > 1) {
            this.getDocument().sendWarning(Messages.CharacterMatcher_Only_Recognize_First_Child, this);
        }
    }
}

