/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.AndMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.IdentifierMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.StartOfLineMatcher;
import com.aptana.ide.lexer.matcher.StringMatcher;
import com.aptana.ide.lexer.matcher.ToDelimiterMatcher;
import com.aptana.ide.lexer.matcher.WhitespaceMatcher;
import com.aptana.ide.lexer.matcher.ZeroOrMoreMatcher;

public class HereDocument
extends AbstractTextMatcher {
    private IdentifierMatcher _identifier = new IdentifierMatcher();

    public void addChildTypes() {
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        map.addCharacterMatcher('<', target);
    }

    public int match(char[] source, int offset, int eofOffset) {
        int index = offset;
        int result = -1;
        if (index + 1 < eofOffset && source[index] == '<' && source[index + 1] == '<') {
            boolean indent = false;
            if ((index += 2) < eofOffset && source[index] == '-') {
                indent = true;
                ++index;
            }
            if (index < eofOffset) {
                char c = source[index];
                int start = index;
                int end = -1;
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '`': {
                        end = this.findClosingQuote(source, ++start, eofOffset, c);
                        break;
                    }
                    default: {
                        end = this._identifier.match(source, start, eofOffset);
                    }
                }
                if (end != -1) {
                    String label = new String(source, start, end - start);
                    index = end;
                    result = this.findDelimiter(source, index, eofOffset, label, indent);
                }
            }
        }
        if (result != -1) {
            this.accept(source, offset, result, this.token);
        }
        return result;
    }

    private int findDelimiter(char[] source, int index, int eofOffset, String label, boolean indent) {
        AndMatcher and = new AndMatcher();
        StartOfLineMatcher lineStart = new StartOfLineMatcher();
        and.appendChild(lineStart);
        if (indent) {
            ZeroOrMoreMatcher whitespace = new ZeroOrMoreMatcher();
            whitespace.appendChild(new WhitespaceMatcher());
            and.appendChild(whitespace);
        }
        StringMatcher marker = new StringMatcher(label);
        and.appendChild(marker);
        ToDelimiterMatcher delimiter = new ToDelimiterMatcher();
        delimiter.appendChild(and);
        delimiter.setMatchEndOfFile(true);
        return delimiter.match(source, index, eofOffset);
    }

    private int findClosingQuote(char[] source, int offset, int eofOffset, char c) {
        int index = offset;
        int result = -1;
        while (index < eofOffset) {
            if (source[index] == c) {
                result = index;
                break;
            }
            ++index;
        }
        return result;
    }
}

