/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import java.util.Arrays;

public class QuotedStringMatcher
extends AbstractTextMatcher {
    private char[] _quotes;
    private boolean _escapeCharacters;
    private boolean _multiLine;
    private IToken _errorToken;

    public QuotedStringMatcher() {
        this("\"");
    }

    public QuotedStringMatcher(String quotes) {
        this.appendText(quotes);
        this._escapeCharacters = true;
        this._multiLine = false;
    }

    public void addChildTypes() {
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        char[] quotes = this.getCharacters();
        if (quotes != null) {
            int i = 0;
            while (i < quotes.length) {
                map.addCharacterMatcher(quotes[i], target);
                ++i;
            }
        }
    }

    public void appendText(String text) {
        if (text != null && text.length() > 0) {
            this._quotes = text.toCharArray();
            Arrays.sort(this._quotes);
        }
    }

    protected void createToken(ITokenList tokenList) {
        super.createToken(tokenList);
        String type = this.getType();
        if (type != null && type.length() > 0) {
            String group = this.getGroup();
            String category = "ERROR";
            String newGroup = this.getSwitchTo();
            IToken token = tokenList.createToken();
            token.setLexerGroup(group);
            token.setCategory(category);
            token.setType(type);
            token.setNewLexerGroup(newGroup);
            tokenList.add(token);
            this._errorToken = token;
        }
    }

    public int match(char[] source, int offset, int eofset) {
        char[] quotes;
        int index;
        int result = offset;
        if (result < eofset && (index = Arrays.binarySearch(quotes = this.getCharacters(), source[result])) >= 0) {
            char quote = quotes[index];
            switch (quote) {
                case '(': {
                    quote = ')';
                    break;
                }
                case '{': {
                    quote = '}';
                    break;
                }
                case '[': {
                    quote = ']';
                    break;
                }
                case '<': {
                    quote = '>';
                    break;
                }
            }
            ++result;
            while (result < eofset) {
                char c = source[result];
                if (source[result] == quote) {
                    ++result;
                    break;
                }
                if (c == '\\' && this._escapeCharacters) {
                    if (++result >= eofset) continue;
                    c = source[result];
                    if (c != '\r' || ++result >= eofset || (c = source[result]) != '\n') continue;
                    ++result;
                    continue;
                }
                if (!this._multiLine && (c == '\r' || c == '\n')) break;
                ++result;
            }
        }
        if (result != offset) {
            IToken token = result - offset >= 2 && source[result - 1] == source[offset] ? this.token : this._errorToken;
            this.accept(source, offset, result, token);
        } else {
            result = -1;
        }
        return result;
    }

    private char[] getCharacters() {
        if (this._quotes == null) {
            this._quotes = this.getText().toCharArray();
        }
        return this._quotes;
    }

    public void setEscapeCharacters(boolean flag) {
        this._escapeCharacters = flag;
    }

    public void setMultiLine(boolean flag) {
        this._multiLine = flag;
    }
}

