/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.Messages;
import com.aptana.ide.lexer.matcher.model.UseElement;
import java.util.Locale;

public class StringMatcher
extends AbstractTextMatcher {
    private char[] _chars;
    private boolean _caseInsensitive;

    public StringMatcher() {
        this(null);
    }

    public StringMatcher(String text) {
        this.appendText(text);
    }

    public void addChildTypes() {
        this.addChildType(UseElement.class);
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        if (this.getChildCount() > 0) {
            map.addUncategorizedMatcher(target);
        } else {
            char[] chars = this.getCharacters();
            if (chars.length > 0) {
                char c = chars[0];
                if (this._caseInsensitive && Character.isLetter(c)) {
                    map.addCharacterMatcher(Character.toLowerCase(c), target);
                    map.addCharacterMatcher(Character.toUpperCase(c), target);
                } else {
                    map.addCharacterMatcher(c, target);
                }
            }
        }
    }

    public boolean getCaseInsensitive() {
        return this._caseInsensitive;
    }

    private char[] getCharacters() {
        if (this.getChildCount() > 0) {
            UseElement use = (UseElement)this.getChild(0);
            String text = use.getText();
            this._chars = this._caseInsensitive ? text.toLowerCase(Locale.getDefault()).toCharArray() : text.toCharArray();
        } else if (this._chars == null) {
            this._chars = this._caseInsensitive ? this.getText().toLowerCase(Locale.getDefault()).toCharArray() : this.getText().toCharArray();
        }
        return this._chars;
    }

    public int match(char[] source, int offset, int eofset) {
        int result = offset;
        char[] chars = this.getCharacters();
        int index = 0;
        while (result < eofset && index < chars.length) {
            char c;
            char c2 = c = this._caseInsensitive ? Character.toLowerCase(source[result]) : source[result];
            if (c != chars[index]) break;
            ++result;
            ++index;
        }
        if (index != chars.length || chars.length == 0) {
            result = -1;
        } else {
            this.accept(source, offset, result, this.token);
        }
        return result;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public String toString() {
        return this.getText();
    }

    protected void validateLocal() {
        super.validateLocal();
        String text = this.getText();
        if ((text == null || text.length() == 0) && this.getChildCount() == 0) {
            this.getDocument().sendError(Messages.StringMatcher_No_Text_Or_Use_Element, this);
        } else if (this.getChildCount() > 1) {
            this.getDocument().sendWarning(Messages.StringMatcher_Only_Recognize_First_Child, this);
        }
    }
}

