/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.metadata;

import com.aptana.ide.metadata.EventMetadata;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataItem;
import com.aptana.ide.metadata.MetadataItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementMetadata
extends MetadataItem {
    private static final String EMPTY = "";
    private String fullName = "";
    private Hashtable<String, IMetadataItem> fields = new Hashtable();
    private Hashtable<String, IMetadataItem> events = new Hashtable();

    public void setFullName(String fullname) {
        this.fullName = fullname == null ? EMPTY : fullname;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void addField(FieldMetadata field) {
        this.fields.put(field.getName(), field);
    }

    public Hashtable<String, IMetadataItem> getFields() {
        return this.fields;
    }

    public void addEvent(EventMetadata event) {
        this.events.put(event.getName(), event);
    }

    public Hashtable<String, IMetadataItem> getEvents() {
        return this.events;
    }

    public void setFields(Hashtable<String, IMetadataItem> newFields) {
        this.fields = newFields;
    }

    public void setEvents(Hashtable<String, IMetadataItem> newEvents) {
        this.events = newEvents;
    }

    @Override
    public void read(DataInput input) throws IOException {
        super.read(input);
        this.fullName = input.readUTF();
        int size = input.readInt();
        int i = 0;
        while (i < size) {
            FieldMetadata field = new FieldMetadata();
            field.read(input);
            this.addField(field);
            ++i;
        }
        size = input.readInt();
        i = 0;
        while (i < size) {
            EventMetadata event = new EventMetadata();
            event.read(input);
            this.addEvent(event);
            ++i;
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.writeUTF(this.fullName);
        this.writeHashtable(output, this.fields);
        this.writeHashtable(output, this.events);
    }

    public void merge(ElementMetadata element) {
        super.merge(element);
        Collection<IMetadataItem> fieldSet = element.getFields().values();
        for (FieldMetadata fieldMetadata : fieldSet) {
            this.addField(fieldMetadata);
        }
        Collection<IMetadataItem> eventSet = element.getEvents().values();
        for (EventMetadata eventMetadata : eventSet) {
            this.addEvent(eventMetadata);
        }
        if (this.getFullName() != EMPTY && element.getFullName() != EMPTY) {
            this.setFullName(element.getFullName());
        }
    }
}

