/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.metadata;

import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.metadata.ElementMetadata;
import com.aptana.ide.metadata.EventMetadata;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataItem;
import com.aptana.ide.metadata.ValueMetadata;
import com.aptana.ide.metadata.reader.MetadataObjectsReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataEnvironment {
    private static final String EMPTY = "";
    private Hashtable<String, IMetadataItem> elements = new Hashtable();
    private Hashtable<String, FieldMetadata> allFields = new Hashtable();
    private Hashtable<String, EventMetadata> allEvents = new Hashtable();

    public void addElement(ElementMetadata element) {
        this.elements.put(element.getName(), element);
    }

    public ElementMetadata getElement(Lexeme lexeme) {
        String lexemeText = lexeme.getText().replaceAll("</", EMPTY);
        lexemeText = lexeme.getText().replaceAll("<", EMPTY);
        return (ElementMetadata)this.elements.get(lexemeText);
    }

    public ElementMetadata getElement(String name) {
        if (this.elements.containsKey(name)) {
            return (ElementMetadata)this.elements.get(name);
        }
        return null;
    }

    public ElementMetadata[] getAllElements() {
        return this.elements.values().toArray(new ElementMetadata[0]);
    }

    public ElementMetadata[] getAllElementsWithPrefix(String prefix) {
        Collection<IMetadataItem> vals = this.elements.values();
        ArrayList<ElementMetadata> returnList = new ArrayList<ElementMetadata>();
        for (ElementMetadata elementMetadata : vals) {
            if (!elementMetadata.getName().startsWith(prefix)) continue;
            returnList.add(elementMetadata);
        }
        return returnList.toArray(new ElementMetadata[returnList.size()]);
    }

    public static MetadataEnvironment getMetadataFromResource(InputStream input, MetadataEnvironment environment) {
        MetadataObjectsReader reader = new MetadataObjectsReader(environment);
        try {
            reader.load(input);
        }
        catch (Exception exception) {}
        try {
            input.close();
        }
        catch (IOException iOException) {}
        return environment;
    }

    public Hashtable<String, FieldMetadata> getGlobalFields() {
        return this.allFields;
    }

    public void setGlobalFields(Hashtable<String, FieldMetadata> fields) {
        this.allFields = fields;
    }

    public Hashtable<String, EventMetadata> getGlobalEvents() {
        return this.allEvents;
    }

    public void setGlobalEvents(Hashtable<String, EventMetadata> events) {
        this.allEvents = events;
    }

    public void read(DataInput input) throws IOException {
        String key;
        int size = input.readInt();
        int i = 0;
        while (i < size) {
            key = input.readUTF();
            ElementMetadata element = new ElementMetadata();
            element.read(input);
            this.elements.put(key, element);
            ++i;
        }
        size = input.readInt();
        i = 0;
        while (i < size) {
            key = input.readUTF();
            FieldMetadata field = new FieldMetadata();
            field.read(input);
            this.allFields.put(key, field);
            ++i;
        }
        size = input.readInt();
        i = 0;
        while (i < size) {
            key = input.readUTF();
            EventMetadata event = new EventMetadata();
            event.read(input);
            this.allEvents.put(key, event);
            ++i;
        }
        Enumeration<String> enumeration = this.elements.keys();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            ElementMetadata el = (ElementMetadata)this.elements.get(key);
            Hashtable<String, IMetadataItem> newFields = new Hashtable<String, IMetadataItem>();
            for (FieldMetadata fieldMetadata : el.getFields().values()) {
                if (this.allFields.containsKey(fieldMetadata.getName()) && fieldMetadata.getValues().size() == 0) {
                    FieldMetadata fmNew = this.allFields.get(fieldMetadata.getName());
                    newFields.put(fieldMetadata.getName(), fmNew);
                    continue;
                }
                newFields.put(fieldMetadata.getName(), fieldMetadata);
            }
            el.setFields(newFields);
            Hashtable<String, IMetadataItem> hashtable = new Hashtable<String, IMetadataItem>();
            for (EventMetadata eventMetadata : el.getEvents().values()) {
                if (this.allEvents.containsKey(eventMetadata.getName())) {
                    EventMetadata emNew = this.allEvents.get(eventMetadata.getName());
                    hashtable.put(eventMetadata.getName(), emNew);
                    continue;
                }
                hashtable.put(eventMetadata.getName(), eventMetadata);
            }
            el.setEvents(hashtable);
        }
    }

    public void write(DataOutput output) throws IOException {
        this.writeHashtable(output, this.elements);
        this.writeHashtable(output, this.allFields);
        this.writeHashtable(output, this.allEvents);
    }

    private void writeHashtable(DataOutput output, Hashtable<String, ? extends IMetadataItem> table) throws IOException {
        Set<String> keySet = table.keySet();
        String[] keys = keySet.toArray(new String[0]);
        output.writeInt(keys.length);
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            IMetadataItem item = table.get(key);
            output.writeUTF(key);
            item.write(output);
            ++i;
        }
    }

    public static String getValueDocumentation(ValueMetadata element) {
        StringBuffer docText = new StringBuffer();
        docText.append("<b>" + element.getName() + "</b>");
        docText.append("<br>" + element.getDescription());
        return docText.toString();
    }
}

