/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.metadata.reader;

import com.aptana.ide.io.TabledInputStream;
import com.aptana.ide.metadata.ElementMetadata;
import com.aptana.ide.metadata.MetadataEnvironment;
import com.aptana.ide.metadata.reader.Messages;
import com.aptana.ide.metadata.reader.MetadataReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;

public class MetadataObjectsReader {
    private MetadataEnvironment environment;

    public MetadataObjectsReader(MetadataEnvironment environment) {
        this.environment = environment;
    }

    public void load(String filename) throws Exception {
        FileInputStream istream = null;
        try {
            try {
                istream = new FileInputStream(filename);
                this.load(istream);
            }
            catch (FileNotFoundException e) {
                String msg = MessageFormat.format(Messages.MetadataObjectsReader_UnableToLocateDocumentationXML, filename);
                Exception de = new Exception(msg, e);
                throw de;
            }
        }
        finally {
            try {
                istream.close();
            }
            catch (IOException e) {
                String msg = Messages.MetadataObjectsReader_IOErrorOccurredProcessingDocumentationXML;
                Exception de = new Exception(msg, e);
                throw de;
            }
        }
    }

    public void load(InputStream stream) throws Exception {
        try {
            TabledInputStream input = new TabledInputStream(stream);
            this.environment.read(input);
        }
        catch (IOException e) {
            String msg = Messages.MetadataObjectsReader_IOErrorOccurredProcessingDocumentationBinary;
            Exception de = new Exception(msg, e);
            throw de;
        }
    }

    public void loadXML(String filename) throws Exception {
        FileInputStream istream = null;
        try {
            try {
                istream = new FileInputStream(filename);
                this.loadXML(istream);
            }
            catch (FileNotFoundException e) {
                String msg = MessageFormat.format(Messages.MetadataObjectsReader_UnableToLocateDocumentationXML, filename);
                Exception de = new Exception(msg, e);
                throw de;
            }
        }
        finally {
            try {
                istream.close();
            }
            catch (IOException e) {
                String msg = Messages.MetadataObjectsReader_IOErrorOccurredProcessingDocumentationXML;
                Exception de = new Exception(msg, e);
                throw de;
            }
        }
    }

    public void loadXML(InputStream stream) throws Exception {
        MetadataReader reader = new MetadataReader();
        reader.loadXML(stream);
        Hashtable fields = reader.getGlobalFields();
        Hashtable events = reader.getGlobalEvents();
        this.environment.setGlobalFields(fields);
        this.environment.setGlobalEvents(events);
        ArrayList elements = reader.getElements();
        int i = 0;
        while (i < elements.size()) {
            ElementMetadata el = (ElementMetadata)elements.get(i);
            this.environment.addElement(el);
            ++i;
        }
    }
}

