/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing;

import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.IParseNodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseState
implements IParseState {
    private static final String EMPTY = "";
    private static final char[] NO_CHARS = new char[0];
    private List<IParseState> _children;
    private List<IParseNode> _comments = new ArrayList<IParseNode>();
    private List<IRange> _updateRegions = new ArrayList<IRange>();
    private LexemeList _lexemes;
    private int _fileIndex = -1;
    private char[] _source;
    private char[] _insertedText;
    private int _startingOffset;
    private int _removeLength;
    private long _parseTime;
    Map<Object, Object> updatedProperties = new HashMap<Object, Object>();
    protected IParseNode parseResults;

    public ParseState() {
        this._lexemes = new LexemeList();
    }

    @Override
    public void addChildState(IParseState child) {
        if (this._children == null) {
            this._children = new ArrayList<IParseState>();
        }
        this._children.add(child);
    }

    @Override
    public void addCommentRegion(IParseNode node) {
        this._comments.add(node);
    }

    @Override
    public void addUpdateRegion(IRange range) {
        this._updateRegions.add(range);
    }

    @Override
    public void clearCommentRegions() {
        this._comments.clear();
    }

    @Override
    public void clearEditState() {
        this._insertedText = NO_CHARS;
        this._removeLength = 0;
    }

    @Override
    public void clearUpdateRegions() {
        this._updateRegions.clear();
    }

    @Override
    public IParseState[] getChildren() {
        return this._children.toArray(new IParseState[0]);
    }

    @Override
    public IParseNode[] getCommentRegions() {
        return this._comments.toArray(new IParseNode[0]);
    }

    private Lexeme getEndingLexeme() {
        Lexeme candidate;
        LexemeList lexemes = this.getLexemeList();
        int lexemeCount = lexemes.size();
        int endingOffset = this.getStartingOffset() + this.getRemoveLength();
        int index = lexemes.getLexemeIndex(endingOffset);
        Lexeme result = null;
        if (index < 0) {
            if ((index = -(index + 1)) < lexemeCount) {
                candidate = lexemes.get(index);
                if (candidate.offset == endingOffset) {
                    result = candidate;
                }
            }
        } else {
            result = lexemes.get(index);
        }
        if (result != null && ++index < lexemeCount) {
            candidate = lexemes.get(index);
            if (result.getEndingOffset() == candidate.offset) {
                result = candidate;
            }
        }
        return result;
    }

    @Override
    public int getFileIndex() {
        return this._fileIndex;
    }

    @Override
    public char[] getInsertedText() {
        char[] result = this._insertedText;
        if (result == null) {
            result = NO_CHARS;
        }
        return result;
    }

    @Override
    public String getLanguage() {
        return EMPTY;
    }

    @Override
    public LexemeList getLexemeList() {
        return this._lexemes;
    }

    @Override
    public IParseState getParent() {
        return null;
    }

    @Override
    public IParseNodeFactory getParseNodeFactory() {
        return null;
    }

    @Override
    public IParseNode getParseResults() {
        return this.parseResults;
    }

    @Override
    public IParseState getParseState(String language) {
        return this;
    }

    @Override
    public long getParseTime() {
        return this._parseTime;
    }

    @Override
    public int getRemoveLength() {
        return this._removeLength;
    }

    @Override
    public IParseState getRoot() {
        return null;
    }

    @Override
    public char[] getSource() {
        char[] result = this._source;
        if (result == null) {
            result = NO_CHARS;
        }
        return result;
    }

    private Lexeme getStartingLexeme() {
        LexemeList lexemes = this.getLexemeList();
        int startingOffset = this.getStartingOffset();
        int index = lexemes.getLexemeIndex(startingOffset);
        Lexeme result = null;
        if (index < 0) {
            Lexeme candidate;
            if ((index = -(index + 1)) > 0 && (candidate = lexemes.get(index - 1)).getEndingOffset() == startingOffset) {
                result = candidate;
            }
        } else {
            Lexeme candidate;
            result = index > 0 ? ((candidate = lexemes.get(index - 1)).getEndingOffset() == startingOffset ? candidate : lexemes.get(index)) : lexemes.get(index);
        }
        return result;
    }

    @Override
    public int getStartingOffset() {
        return this._startingOffset;
    }

    @Override
    public Map<Object, Object> getUpdatedProperties() {
        return this.updatedProperties;
    }

    @Override
    public IRange[] getUpdateRegions() {
        return this._updateRegions.toArray(new IRange[this._updateRegions.size()]);
    }

    private void insertText() {
        int insertedLength = this.getInsertedText().length;
        if (insertedLength > 0) {
            Lexeme lexeme;
            LexemeList lexemes = this.getLexemeList();
            Range affectedRegion = lexemes.getAffectedRegion();
            int resizeDelta = insertedLength - this.getRemoveLength();
            int startingOffset = this.getStartingOffset();
            int insertIndex = lexemes.getLexemeIndex(startingOffset + this.getRemoveLength());
            if (insertIndex < 0) {
                insertIndex = -(insertIndex + 1);
            }
            if (insertIndex >= 0 && insertIndex < lexemes.size()) {
                lexeme = lexemes.get(insertIndex);
                if (lexeme.offset <= startingOffset) {
                    affectedRegion.includeInRange(lexeme.offset);
                }
                affectedRegion.includeInRange(lexeme.getEndingOffset() + resizeDelta);
                lexemes.remove(insertIndex);
            }
            if ((insertIndex = lexemes.getLexemeIndex(startingOffset)) < 0) {
                insertIndex = -(insertIndex + 1);
            }
            if (insertIndex > 0 && (lexeme = lexemes.get(insertIndex - 1)).getEndingOffset() == startingOffset) {
                affectedRegion.includeInRange(lexeme);
                lexemes.remove(insertIndex - 1);
            }
        }
    }

    @Override
    public void onAfterParse() {
        if (this._children != null && this._children.size() > 0) {
            int i = 0;
            while (i < this._children.size()) {
                this._children.get(i).onAfterParse();
                ++i;
            }
        }
    }

    @Override
    public void onBeforeParse() {
        if (this._children != null && this._children.size() > 0) {
            int i = 0;
            while (i < this._children.size()) {
                this._children.get(i).onBeforeParse();
                ++i;
            }
        }
        this.clearCommentRegions();
        this.clearUpdateRegions();
    }

    @Override
    public void removeChildState(IParseState child) {
        if (this._children != null) {
            this._children.remove(child);
        }
    }

    private void removeText() {
        int removeLength = this.getRemoveLength();
        if (removeLength > 0) {
            LexemeList lexemes = this.getLexemeList();
            Range affectedRegion = lexemes.getAffectedRegion();
            int startingOffset = this.getStartingOffset();
            int insertedLength = this.getInsertedText().length;
            int resizeDelta = insertedLength - removeLength;
            Lexeme startingLexeme = this.getStartingLexeme();
            Lexeme endingLexeme = this.getEndingLexeme();
            if (startingLexeme != null && endingLexeme != null) {
                affectedRegion.includeInRange(startingLexeme.offset);
                affectedRegion.includeInRange(endingLexeme.getEndingOffset() + resizeDelta);
                lexemes.remove(startingLexeme, endingLexeme);
            } else {
                if (startingLexeme != null && (startingLexeme.containsOffset(startingOffset) || startingLexeme.getEndingOffset() == startingOffset)) {
                    affectedRegion.includeInRange(startingLexeme.offset);
                    lexemes.remove(startingLexeme);
                }
                if (endingLexeme != null) {
                    affectedRegion.includeInRange(endingLexeme.getEndingOffset() + resizeDelta);
                    lexemes.remove(endingLexeme);
                }
                int startingIndex = lexemes.getLexemeCeilingIndex(startingOffset);
                int endingIndex = lexemes.getLexemeFloorIndex(startingOffset + removeLength - 1);
                if (startingIndex != -1 && endingIndex != -1 && startingIndex <= endingIndex) {
                    startingLexeme = lexemes.get(startingIndex);
                    endingLexeme = lexemes.get(endingIndex);
                    lexemes.remove(startingLexeme, endingLexeme);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        LexemeList ll;
        LexemeList lexemeList = ll = this.getLexemeList();
        synchronized (lexemeList) {
            ll.clear();
        }
        if (this._children != null) {
            int i = 0;
            while (i < this._children.size()) {
                IParseState child = this._children.get(i);
                child.reset();
                ++i;
            }
        }
    }

    @Override
    public void setEditState(String source, String insertedSource, int offset, int removeLength) {
        this._source = source != null ? source.toCharArray() : NO_CHARS;
        this._insertedText = insertedSource != null ? insertedSource.toCharArray() : NO_CHARS;
        this._startingOffset = offset;
        this._removeLength = removeLength;
        this.updateLexemeList();
    }

    @Override
    public void setFileIndex(int index) {
        this.unloadFromEnvironment();
        this._fileIndex = index;
    }

    @Override
    public void setParseResults(IParseNode results) {
        this.parseResults = results;
    }

    @Override
    public void setParseTime(long elapsedMilliseconds) {
        this._parseTime = elapsedMilliseconds;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int insertedLength = this._insertedText.length;
        sb.append("@").append(this._startingOffset);
        if (this._removeLength > 0 || insertedLength > 0) {
            if (this._removeLength > 0) {
                sb.append(":r").append(this._removeLength);
            }
            if (insertedLength > 0) {
                sb.append(":i").append(insertedLength).append(":").append(this._insertedText);
            } else {
                sb.append(":");
            }
        } else {
            sb.append(":");
        }
        return sb.toString();
    }

    @Override
    public void unloadFromEnvironment() {
        int i = 0;
        while (i < this._children.size()) {
            IParseState child = this._children.get(i);
            child.unloadFromEnvironment();
            ++i;
        }
    }

    protected void updateLexemeList() {
        LexemeList lexemes = this.getLexemeList();
        int startingOffset = this.getStartingOffset();
        int insertedLength = this.getInsertedText().length;
        lexemes.getAffectedRegion().setRange(startingOffset, startingOffset + insertedLength);
        this.removeText();
        this.insertText();
        this.updateLexemeOffsets();
    }

    private void updateLexemeOffsets() {
        LexemeList lexemes = this.getLexemeList();
        char[] insertedText = this.getInsertedText();
        int insertedLength = insertedText != null ? insertedText.length : 0;
        int resizeDelta = insertedLength - this.getRemoveLength();
        if (resizeDelta != 0) {
            int insertIndex = lexemes.getLexemeIndex(this.getStartingOffset());
            if (insertIndex < 0) {
                insertIndex = -(insertIndex + 1);
            }
            lexemes.shiftLexemeOffsets(insertIndex, resizeDelta);
        }
    }
}

