/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.bnf;

import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.parsing.bnf.TerminalList;
import com.aptana.ide.parsing.bnf.nodes.GrammarNode;
import com.aptana.ide.parsing.bnf.nodes.IGrammarNode;
import com.aptana.ide.parsing.bnf.nodes.NonTerminalNode;
import com.aptana.ide.parsing.bnf.nodes.ProductionNode;
import com.aptana.ide.parsing.bnf.nodes.TerminalNode;

public class Item {
    private ProductionNode _production;
    private IGrammarNode _definition;
    private int _position;

    public Item(ProductionNode production) {
        this._production = production;
        IGrammarNode child = (IGrammarNode)this._production.getChild(0);
        this._definition = child.getTypeIndex() == 3 ? child : production;
    }

    public Item(Item item) {
        this._production = item._production;
        this._definition = item._definition;
        this._position = item._position;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof Item) {
            Item that = (Item)obj;
            result = this._production == that._production && this._position == that._position;
        }
        return result;
    }

    public boolean isAtNonTerminal() {
        IGrammarNode currentNode = this.getCurrentNode();
        return currentNode != null && currentNode instanceof NonTerminalNode;
    }

    public boolean isInitialItem() {
        return this._position == 0;
    }

    public boolean isCompletedItem() {
        return this._position == this._definition.getChildCount();
    }

    public void advance() {
        if (!this.isCompletedItem()) {
            ++this._position;
        }
    }

    public IGrammarNode getCurrentNode() {
        IGrammarNode result = null;
        if (!this.isCompletedItem()) {
            result = (IGrammarNode)this._definition.getChild(this._position);
        }
        return result;
    }

    public void getFollow(TerminalList terminals) {
        IGrammarNode currentNode = this.getCurrentNode();
        this.advance();
        if (this.isCompletedItem()) {
            currentNode.getOwningProduction().getFollow(terminals);
        } else {
            IGrammarNode sibling = this.getCurrentNode();
            switch (sibling.getTypeIndex()) {
                case 56: {
                    terminals.add((TerminalNode)sibling);
                    break;
                }
                case 4: {
                    NonTerminalNode nonTerminal = (NonTerminalNode)sibling;
                    TerminalList first = new TerminalList();
                    nonTerminal.getFirst(first);
                    first.removeEpsilon();
                    terminals.add(first);
                    if (!nonTerminal.isNullable()) break;
                    sibling.getOwningProduction().getFollow(terminals);
                    break;
                }
            }
        }
    }

    public int hashCode() {
        return this._production.hashCode() ^ this._position;
    }

    public int getIndex() {
        GrammarNode grammar = this._production.getOwningGrammar();
        int result = -1;
        int i = 0;
        while (i < grammar.getChildCount()) {
            if (grammar.getChild(i) == this._production) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public String getName() {
        return this._production.getName();
    }

    public int getPosition() {
        return this._position;
    }

    public void setPosition(int position) {
        if (this._definition != null && position >= 0 && position <= this._definition.getChildCount()) {
            this._position = position;
        }
    }

    public String toString() {
        SourceWriter writer = new SourceWriter();
        writer.print(this._production.getName()).print(" : ");
        int i = 0;
        while (i < this._definition.getChildCount()) {
            if (i == this._position) {
                writer.print(". ");
            }
            this._definition.getChild(i).getSource(writer);
            if (i < this._definition.getChildCount() - 1) {
                writer.print(" ");
            }
            ++i;
        }
        if (this._position == this._definition.getChildCount()) {
            writer.print(".");
        }
        return writer.toString();
    }
}

