/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.bnf;

import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.parsing.AbstractParser;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.bnf.Action;
import com.aptana.ide.parsing.bnf.IReductionContext;
import com.aptana.ide.parsing.bnf.IReductionHandler;
import com.aptana.ide.parsing.bnf.Item;
import com.aptana.ide.parsing.bnf.ReductionContext;
import com.aptana.ide.parsing.bnf.State;
import com.aptana.ide.parsing.bnf.nodes.GrammarNode;
import com.aptana.ide.parsing.bnf.nodes.IGrammarNode;
import com.aptana.ide.parsing.bnf.nodes.ProductionNode;
import com.aptana.ide.parsing.bnf.nodes.SequenceNode;
import com.aptana.ide.parsing.bnf.nodes.TerminalNode;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class LRParser
extends AbstractParser {
    protected GrammarNode _grammar;
    private GrammarNode _expandedGrammar;
    private State[] _states;
    private List<IReductionHandler> _handlers;
    private String _message;

    protected LRParser(String language) throws ParserInitializationException {
        super(language);
        this._states = this.createStateTable();
    }

    protected LRParser(TokenList tokenList, GrammarNode grammar) throws ParserInitializationException {
        super(tokenList);
        this._grammar = grammar;
        this._states = this.createStateTable();
    }

    public void addHandler(IReductionHandler handler) {
        if (this._handlers == null) {
            this._handlers = new ArrayList<IReductionHandler>();
        }
        this._handlers.add(handler);
    }

    protected IReductionContext createReductionContext(String productionName, SequenceNode rule) {
        return new ReductionContext(productionName, rule, this);
    }

    private State[] createStateTable() {
        ArrayList<State> states = new ArrayList<State>();
        GrammarNode grammar = this.getGrammar();
        if (grammar != null) {
            GrammarNode expandedGrammar = grammar.getExpandedGrammar();
            this._expandedGrammar = grammar.getExpandedGrammar();
            Item startItem = new Item((ProductionNode)expandedGrammar.getChild(0));
            HashMap<String, State> stateCache = new HashMap<String, State>();
            states.add(new State(expandedGrammar, startItem));
            int index = 0;
            while (index < states.size()) {
                State currentState = (State)states.get(index);
                for (IGrammarNode transition : currentState.getTransitionInputs()) {
                    String name = transition.getName();
                    State newState = currentState.getTransitionState(transition, stateCache);
                    if (newState.getIndex() == -1) {
                        newState.setIndex(states.size());
                        states.add(newState);
                    }
                    if (transition.getTypeIndex() == 4) {
                        currentState.addGoto(name, newState.getIndex());
                        continue;
                    }
                    currentState.addShift(name, newState.getIndex());
                }
                ++index;
            }
            for (State state : states) {
                Item[] itemArray = state.getItems();
                int n = 0;
                int n2 = itemArray.length;
                while (n < n2) {
                    Item item = itemArray[n];
                    if (item.isCompletedItem()) {
                        String name = item.getName();
                        if (expandedGrammar.getStartingName().equals(name)) {
                            state.addAccept("$");
                        } else {
                            int newState = item.getIndex();
                            for (TerminalNode terminal : expandedGrammar.getFollow(name)) {
                                state.addReduce(terminal.getName(), newState);
                            }
                        }
                    }
                    ++n;
                }
            }
        }
        return states.toArray(new State[states.size()]);
    }

    private void fireOnAfterParse(IParseNode parentNode) {
        if (this._handlers != null) {
            IParseState parseState = this.getParseState();
            for (IReductionHandler handler : this._handlers) {
                handler.afterParse(parseState, parentNode);
            }
        }
    }

    private void fireOnBeforeParse(IParseNode parentNode) {
        if (this._handlers != null) {
            IParseState parseState = this.getParseState();
            for (IReductionHandler handler : this._handlers) {
                handler.beforeParse(parseState, parentNode);
            }
        }
    }

    private void fireReductions(ProductionNode production) {
        if (this._handlers != null && production != null) {
            String productionName = production.getName();
            SequenceNode rule = (SequenceNode)production.getChild(0);
            IReductionContext context = this.createReductionContext(productionName, rule);
            for (IReductionHandler handler : this._handlers) {
                handler.reduce(context);
            }
        }
    }

    public GrammarNode getExpandedGrammar() {
        return this._expandedGrammar;
    }

    public GrammarNode getGrammar() {
        return this._grammar;
    }

    public String getMessage() {
        return this._message;
    }

    public void parseAll(IParseNode parentNode) throws ParseException, LexerException {
        IParseNode rootNode = this.getParseRootNode(parentNode, IParseNode.class);
        boolean accept = false;
        boolean error = false;
        Stack<State> states = new Stack<State>();
        this.fireOnBeforeParse(rootNode);
        if (this._states != null && this._states.length > 0) {
            State currentState = this._states[0];
            states.push(currentState);
            this.advance();
            this._message = "";
            block7: while (!accept && !error) {
                Action action = currentState.getAction(this.currentLexeme.getType());
                switch (action.type) {
                    case SHIFT: {
                        this.pushCurrentLexeme(this.currentLexeme);
                        if (this.isEOS()) continue block7;
                        this.advance();
                        currentState = this._states[action.newState];
                        states.push(currentState);
                        break;
                    }
                    case REDUCE: {
                        ProductionNode production = (ProductionNode)this._expandedGrammar.getChild(action.newState);
                        String name = production.getName();
                        int symbolCount = production.getSymbolCount();
                        int i = 0;
                        while (i < symbolCount) {
                            states.pop();
                            ++i;
                        }
                        this.fireReductions(production);
                        Action newAction = ((State)states.peek()).getAction(name);
                        currentState = this._states[newAction.newState];
                        states.push(currentState);
                        break;
                    }
                    case ACCEPT: {
                        accept = true;
                        break;
                    }
                    case GOTO: {
                        this._message = "Unexpected goto at " + this.currentLexeme + " in state " + currentState.getIndex();
                        error = true;
                        break;
                    }
                    case ERROR: {
                        if (this.recover()) {
                            currentState = this._states[0];
                            states.clear();
                            states.push(currentState);
                            break;
                        }
                        this._message = "No transition for " + this.currentLexeme + " in state " + currentState.getIndex();
                        error = true;
                        break;
                    }
                }
            }
        }
        this.fireOnAfterParse(rootNode);
    }

    private void pushCurrentLexeme(Lexeme currentLexeme) {
        if (this._handlers != null) {
            for (IReductionHandler handler : this._handlers) {
                handler.push(currentLexeme);
            }
        }
    }

    protected boolean recover() {
        return false;
    }

    public void removeHandler(IReductionHandler handler) {
        if (this._handlers != null) {
            this._handlers.remove(handler);
        }
    }
}

