/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.bnf;

import com.aptana.ide.io.StreamUtils;
import com.aptana.ide.lexer.IEnumerationMap;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.TokenList;
import com.aptana.ide.lexer.matcher.MatcherLexerBuilder;
import com.aptana.ide.lexer.matcher.MatcherTokenList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.ParsingPlugin;
import com.aptana.ide.parsing.bnf.BNFGrammar;
import com.aptana.ide.parsing.bnf.BNFHandler;
import com.aptana.ide.parsing.bnf.LRParser;
import com.aptana.ide.parsing.bnf.nodes.GrammarNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class LRParserBuilder {
    private static LRParser bnfParser;
    private static BNFHandler handler;

    public IParser buildParser(InputStream bnfStream, InputStream lexerStream) {
        LRParser result = null;
        if (bnfStream != null && lexerStream != null) {
            GrammarNode grammar = LRParserBuilder.createGrammar(bnfStream);
            TokenList tokenList = LRParserBuilder.createTokenList(lexerStream);
            if (grammar != null && tokenList != null) {
                try {
                    result = new LRParser(tokenList, grammar);
                }
                catch (ParserInitializationException parserInitializationException) {}
            }
        }
        return result;
    }

    private static LRParser createBNFParser() {
        LRParser result = null;
        try {
            InputStream input = LRParserBuilder.class.getResourceAsStream("/com/aptana/ide/parsing/bnf/resources/BNF.lxr");
            TokenList tokenList = LRParserBuilder.createTokenList(input);
            result = new LRParser(tokenList, BNFGrammar.getGrammar()){

                public void initializeLexer() throws LexerException {
                    ILexer lexer = this.getLexer();
                    String language = this.getLanguage();
                    MatcherTokenList tokenList = (MatcherTokenList)lexer.getTokenList(language);
                    IEnumerationMap typeMap = tokenList.getTypeMap();
                    int[] set = new int[]{typeMap.getIntValue("WHITESPACE"), typeMap.getIntValue("COMMENT")};
                    Arrays.sort(set);
                    lexer.setIgnoreSet(language, set);
                    lexer.setLanguageAndGroup(language, "default");
                }
            };
            handler = new BNFHandler();
            result.addHandler(handler);
        }
        catch (ParserInitializationException parserInitializationException) {}
        return result;
    }

    public static GrammarNode createGrammar(InputStream bnfStream) {
        GrammarNode result = null;
        if (bnfStream != null) {
            try {
                String bnfSource = StreamUtils.getText(bnfStream);
                if (bnfParser == null) {
                    bnfParser = LRParserBuilder.createBNFParser();
                }
                IParseState parseState = bnfParser.createParseState(null);
                parseState.setEditState(bnfSource, bnfSource, 0, 0);
                bnfParser.parse(parseState);
                result = handler.getGrammar();
            }
            catch (LexerException lexerException) {
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private static TokenList createTokenList(InputStream input) {
        TokenList result = null;
        if (input != null) {
            try {
                MatcherLexerBuilder builder = new MatcherLexerBuilder();
                builder.loadXML(input);
                ILexer lexer = builder.buildLexer();
                String[] languages = lexer.getLanguages();
                if (languages != null && languages.length > 0) {
                    result = (TokenList)lexer.getTokenList(languages[0]);
                }
            }
            catch (Exception e) {
                ParsingPlugin.logError("Cannot create token list", e);
            }
        }
        return result;
    }
}

