/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.bnf;

import com.aptana.ide.parsing.bnf.Action;
import com.aptana.ide.parsing.bnf.ActionType;
import com.aptana.ide.parsing.bnf.Item;
import com.aptana.ide.parsing.bnf.nodes.GrammarNode;
import com.aptana.ide.parsing.bnf.nodes.IGrammarNode;
import com.aptana.ide.parsing.bnf.nodes.ProductionNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    private static final Action ERROR_ACTION = new Action(ActionType.ERROR, -1);
    private GrammarNode _grammar;
    private List<Item> _items;
    private Map<String, Action> _transitions;
    private int _index;

    private State(GrammarNode grammar) {
        this._grammar = grammar;
        this._items = new ArrayList<Item>();
        this._index = -1;
        this._transitions = new HashMap<String, Action>();
    }

    public State(GrammarNode grammar, Item item) {
        this(grammar);
        this._items.add(item);
        this.buildSet();
    }

    public void addAccept(String name) {
        Action action = new Action(ActionType.ACCEPT, -1);
        if (this._transitions.containsKey(name)) {
            System.out.print("Accept state " + action + " not added because ");
            System.out.println(String.valueOf(name) + " is already defined as " + this._transitions.get(name) + ". ");
            System.out.println("  " + this.getIndex() + ": " + this.getHashKey());
        } else {
            this._transitions.put(name, action);
        }
    }

    public void addError(String name, int errorNumber) {
        Action action = new Action(ActionType.ERROR, errorNumber);
        if (this._transitions.containsKey(name)) {
            System.out.print("Error state " + action + " not added because. ");
            System.out.println(String.valueOf(name) + " is already defined as " + this._transitions.get(name) + ". ");
            System.out.println("  " + this.getIndex() + ": " + this.getHashKey());
        } else {
            this._transitions.put(name, action);
        }
    }

    public void addGoto(String name, int newState) {
        Action action = new Action(ActionType.GOTO, newState);
        if (this._transitions.containsKey(name)) {
            System.out.print("Goto state " + action + " not added because ");
            System.out.println(String.valueOf(name) + " is already defined as " + this._transitions.get(name) + ". ");
            System.out.println("  " + this.getIndex() + ": " + this.getHashKey());
        } else {
            this._transitions.put(name, action);
        }
    }

    public void addReduce(String name, int newState) {
        Action action = new Action(ActionType.REDUCE, newState);
        if (!this._transitions.containsKey(name)) {
            this._transitions.put(name, action);
        }
    }

    public void addShift(String name, int newState) {
        Action action = new Action(ActionType.SHIFT, newState);
        if (this._transitions.containsKey(name)) {
            System.out.print("Shift state " + action + " not added because ");
            System.out.println(String.valueOf(name) + " is already defined as " + this._transitions.get(name));
            System.out.println("  " + this.getIndex() + ": " + this.getHashKey());
        } else {
            this._transitions.put(name, action);
        }
    }

    private void buildSet() {
        int index = 0;
        while (index < this._items.size()) {
            Item currentItem = this._items.get(index);
            if (currentItem.isAtNonTerminal() && !currentItem.isCompletedItem()) {
                IGrammarNode current = currentItem.getCurrentNode();
                String name = current.getName();
                ProductionNode[] productions = this._grammar.getProductionsByName(name);
                int i = 0;
                while (i < productions.length) {
                    Item candidate = new Item(productions[i]);
                    if (!this._items.contains(candidate)) {
                        this._items.add(candidate);
                    }
                    ++i;
                }
            }
            ++index;
        }
    }

    public Action getAction(String name) {
        Action result = this._transitions.get(name);
        if (result == null) {
            result = ERROR_ACTION;
        }
        return result;
    }

    private String getHashKey() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this._items.size()) {
            Item item = this._items.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(item.toString());
            ++i;
        }
        return buffer.toString();
    }

    public int getIndex() {
        return this._index;
    }

    public Item[] getItems() {
        return this._items.toArray(new Item[this._items.size()]);
    }

    public List<IGrammarNode> getTransitionInputs() {
        ArrayList<IGrammarNode> result = new ArrayList<IGrammarNode>();
        for (Item item : this._items) {
            IGrammarNode currentNode = item.getCurrentNode();
            if (currentNode == null || result.contains(currentNode)) continue;
            result.add(currentNode);
        }
        return result;
    }

    public State getTransitionState(IGrammarNode input, Map<String, State> stateMap) {
        State state = new State(this._grammar);
        for (Item item : this._items) {
            if (item.isCompletedItem() || !item.getCurrentNode().equals(input)) continue;
            Item newItem = new Item(item);
            newItem.advance();
            state._items.add(newItem);
        }
        state.buildSet();
        if (stateMap != null) {
            String name = state.getHashKey();
            if (stateMap.containsKey(name)) {
                state = stateMap.get(name);
            } else {
                stateMap.put(name, state);
            }
        }
        return state;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        int i = 0;
        while (i < this._items.size()) {
            writer.println(this._items.get(i).toString());
            ++i;
        }
        return sw.toString();
    }
}

