/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.bnf.nodes;

import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.parsing.bnf.Item;
import com.aptana.ide.parsing.bnf.TerminalList;
import com.aptana.ide.parsing.bnf.nodes.GrammarNode;
import com.aptana.ide.parsing.bnf.nodes.GrammarNodeBase;
import com.aptana.ide.parsing.bnf.nodes.IGrammarNode;
import com.aptana.ide.parsing.bnf.nodes.NonTerminalNode;
import com.aptana.ide.parsing.bnf.nodes.ProductionNode;
import com.aptana.ide.parsing.bnf.nodes.TerminalNode;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceNode
extends GrammarNodeBase {
    private String _actionName;
    private Map<String, List<Integer>> _nameIndex = new HashMap<String, List<Integer>>();

    public SequenceNode(GrammarNode owningGrammar) {
        super(owningGrammar, 3, "#sequence");
    }

    @Override
    public void appendChild(IParseNode child) {
        super.appendChild(child);
        if (child instanceof TerminalNode) {
            TerminalNode terminal = (TerminalNode)child;
            this.setNameIndex(terminal.getName());
            this.setNameIndex(terminal.getAlias());
        } else if (child instanceof NonTerminalNode) {
            NonTerminalNode nonTerminal = (NonTerminalNode)child;
            this.setNameIndex(nonTerminal.getName());
        }
    }

    public Item findNonTerminal(String name) {
        Item result = null;
        int i = 0;
        while (i < this.getChildCount()) {
            IGrammarNode child = (IGrammarNode)this.getChild(i);
            if (child.getTypeIndex() == 4 && child.getName().equals(name)) {
                result = new Item((ProductionNode)this.getParent());
                result.setPosition(i);
                break;
            }
            ++i;
        }
        return result;
    }

    public String getActionName() {
        return this._actionName;
    }

    @Override
    public void getFirst(TerminalList terminals) {
        boolean allNullable = true;
        int i = 0;
        while (i < this.getChildCount()) {
            IGrammarNode child = (IGrammarNode)this.getChild(i);
            child.getFirst(terminals);
            if (!child.isNullable()) {
                allNullable = false;
                break;
            }
            ++i;
        }
        if (allNullable) {
            terminals.addEpsilon();
        }
    }

    public Map<String, List<Integer>> getNameIndexMap() {
        return this._nameIndex;
    }

    @Override
    public void getSource(SourceWriter writer) {
        String actionName;
        if (this.hasChildren()) {
            this.getChild(0).getSource(writer);
            int i = 1;
            while (i < this.getChildCount()) {
                writer.print(" ");
                this.getChild(i).getSource(writer);
                ++i;
            }
        }
        if ((actionName = this.getActionName()) != null && actionName.length() > 0) {
            writer.print(" {").print(actionName).print("}");
        }
    }

    @Override
    public void getSymbols(List<IGrammarNode> symbols) {
        int i = 0;
        while (i < this.getChildCount()) {
            IGrammarNode child = (IGrammarNode)this.getChild(i);
            child.getSymbols(symbols);
            ++i;
        }
    }

    @Override
    public boolean isNullable() {
        boolean result = false;
        if (this.getChildCount() == 1) {
            result = ((IGrammarNode)this.getChild(0)).isNullable();
        }
        return result;
    }

    public void setActionName(String name) {
        this._actionName = name;
    }

    private void setNameIndex(String name) {
        int lastIndex = this.getChildCount() - 1;
        if (name != null && name.length() > 0 && lastIndex != -1) {
            if (this._nameIndex == null) {
                this._nameIndex = new HashMap<String, List<Integer>>();
            }
            if (!this._nameIndex.containsKey(name)) {
                this._nameIndex.put(name, new ArrayList());
            }
            List<Integer> indexes = this._nameIndex.get(name);
            indexes.add(lastIndex);
        }
    }
}

