/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.matcher;

import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.matcher.AbstractLexemeMatcher;

public class TokenMatcher
extends AbstractLexemeMatcher {
    private String _category;
    private String _type;
    private String _attribute;

    public void addChildTypes() {
    }

    public String getAttribute() {
        return this._attribute;
    }

    public String getCategory() {
        return this._category;
    }

    public String getType() {
        return this._type;
    }

    public void setAttribute(String attribute) {
        this._attribute = attribute;
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public void setType(String type) {
        this._type = type;
    }

    protected void accept(Lexeme[] lexemes, int startingIndex, int endingIndex) {
        if (this._attribute != null && this._attribute.length() > 0) {
            String value = lexemes[startingIndex].getText();
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            this.addAttribute(this._attribute, value);
        }
        super.accept(lexemes, startingIndex, endingIndex);
    }

    public int match(Lexeme[] lexemes, int offset, int eofOffset) {
        int result = -1;
        this.reset();
        if (offset < eofOffset) {
            String language = this.getOwningParser().getLanguage();
            Lexeme lexeme = lexemes[offset];
            if (lexeme.getLanguage().equals(language)) {
                String category = this.getCategory();
                String type = this.getType();
                boolean match = true;
                if (category != null && category.length() > 0) {
                    match = lexeme.getCategory().equals(category);
                }
                if (match && type != null && type.length() > 0) {
                    match = lexeme.getType().equals(type);
                }
                if (match) {
                    result = offset + 1;
                }
            }
        }
        if (result != -1) {
            this.accept(lexemes, offset, result);
        }
        return result;
    }
}

