/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.regex;

import com.aptana.ide.regex.Messages;
import com.aptana.ide.regex.dfa.DFAGraph;
import com.aptana.ide.regex.inputs.AnyInput;
import com.aptana.ide.regex.inputs.CharacterClassInput;
import com.aptana.ide.regex.inputs.CharacterInput;
import com.aptana.ide.regex.inputs.DigitInput;
import com.aptana.ide.regex.inputs.Input;
import com.aptana.ide.regex.inputs.WhiteSpaceInput;
import com.aptana.ide.regex.inputs.WordInput;
import com.aptana.ide.regex.nfa.NFAGraph;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexParser {
    private char[] _regex;
    private int _index;
    Stack<NFAGraph> _nfaStack = new Stack();
    int _acceptState;
    DFAGraph _dfa;

    private char getCurrentChar() {
        char result = !this.getEOS() ? this._regex[this._index] : (char)'\u0000';
        return result;
    }

    private boolean isHexDigit() {
        char digit = this.getCurrentChar();
        return '0' <= digit && digit <= '9' || 'A' <= digit && digit <= 'F' || 'a' <= digit && digit <= 'f';
    }

    public DFAGraph getDFAGraph() {
        return this._dfa;
    }

    private boolean getEOS() {
        return this._index >= this._regex.length;
    }

    public NFAGraph getNFAGraph() {
        NFAGraph result = null;
        if (this._nfaStack.size() > 0) {
            result = this._nfaStack.peek();
        }
        return result;
    }

    public Stack<NFAGraph> getNFAStack() {
        return this._nfaStack;
    }

    private boolean isFirstInAndExpression() {
        boolean result = true;
        if (!this.getEOS()) {
            switch (this.getCurrentChar()) {
                case '\u0000': 
                case '$': 
                case ')': 
                case '*': 
                case '+': 
                case '?': 
                case '^': 
                case '|': {
                    result = false;
                    break;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    private void advance() {
        int length = this._regex.length;
        if (this._index < length) {
            ++this._index;
            while (this._index < length && Character.isWhitespace(this._regex[this._index])) {
                ++this._index;
            }
        }
    }

    public void parse(String regex, int acceptState) throws ParseException {
        if (regex == null) {
            throw new NullPointerException(Messages.RegexParser_Undefined);
        }
        if (regex.length() == 0) {
            throw new ParseException(Messages.RegexParser_Empty, 0);
        }
        this._regex = regex.toCharArray();
        this._index = -1;
        this._acceptState = acceptState;
        this.advance();
        if (!this.parseExpression()) {
            Object[] messageArgs = new Object[]{regex, Integer.toString(this._index)};
            String message = MessageFormat.format(Messages.RegexParser_Parse_Error, messageArgs);
            throw new ParseException(message, 0);
        }
    }

    private boolean parseExpression() {
        boolean success = true;
        if (this.getCurrentChar() == '^') {
            this.advance();
        }
        while (success && !this.getEOS()) {
            success = this.parseOrExpression();
            if (this._index != this._regex.length - 1 || this.getCurrentChar() != '$') continue;
            this.advance();
        }
        return success;
    }

    private boolean parseOrExpression() {
        boolean success = true;
        if (this.parseAndExpression()) {
            while (this.getCurrentChar() == '|') {
                this.advance();
                if (this.parseAndExpression()) {
                    NFAGraph rhs = this._nfaStack.pop();
                    NFAGraph lhs = this._nfaStack.peek();
                    lhs.orMachines(rhs);
                    continue;
                }
                success = false;
                break;
            }
        } else {
            success = false;
        }
        return success;
    }

    private boolean parseAndExpression() {
        boolean success = true;
        if (this.isFirstInAndExpression()) {
            this.parseFactor();
            while (this.isFirstInAndExpression()) {
                if (this.parseFactor()) {
                    NFAGraph rhs = this._nfaStack.pop();
                    NFAGraph lhs = this._nfaStack.peek();
                    lhs.andMachines(rhs);
                    continue;
                }
                success = false;
                break;
            }
        } else {
            success = false;
        }
        return success;
    }

    private boolean parseFactor() {
        boolean success = true;
        if (this.parseTerm()) {
            NFAGraph nfa = this._nfaStack.peek();
            switch (this.getCurrentChar()) {
                case '*': {
                    this.advance();
                    nfa.kleeneClosure();
                    break;
                }
                case '+': {
                    this.advance();
                    nfa.positiveClosure();
                    break;
                }
                case '?': {
                    this.advance();
                    nfa.option();
                    break;
                }
            }
        } else {
            success = false;
        }
        return success;
    }

    private boolean parseTerm() {
        boolean success = true;
        if (this.getCurrentChar() == '(') {
            success = this.parseSubExpression();
        } else {
            NFAGraph newState = new NFAGraph(this._acceptState);
            switch (this.getCurrentChar()) {
                case '.': {
                    this.advance();
                    newState.add(new AnyInput());
                    break;
                }
                case '\\': {
                    newState.add(this.parseEscapedTerm());
                    break;
                }
                case '[': {
                    newState.add(this.parseCharacterClass());
                    break;
                }
                default: {
                    newState.add(new CharacterInput(this.getCurrentChar()));
                    this.advance();
                }
            }
            if (success) {
                this._nfaStack.push(newState);
            }
        }
        return success;
    }

    private Input parseCharacterClass() {
        this.advance();
        CharacterClassInput cci = new CharacterClassInput();
        char last = '\u0000';
        if (this.getCurrentChar() == '^') {
            this.advance();
            cci.setComplement(true);
        }
        if (this.getCurrentChar() == '-') {
            cci.addInput('-');
            this.advance();
        }
        block4: while (!this.getEOS() && this.getCurrentChar() != ']') {
            switch (this.getCurrentChar()) {
                case '-': {
                    this.advance();
                    if (last == '\u0000') continue block4;
                    cci.addInputs(last, this.getCurrentChar());
                    this.advance();
                    last = '\u0000';
                    break;
                }
                case '\\': {
                    Input input = this.parseEscapedTerm();
                    cci.addInputs(input.getCharacters());
                    break;
                }
                default: {
                    last = this.getCurrentChar();
                    cci.addInput(last);
                    this.advance();
                }
            }
        }
        if (this.getCurrentChar() == ']') {
            this.advance();
        }
        return cci;
    }

    private Input parseEscapedTerm() {
        Input result = null;
        ++this._index;
        switch (this.getCurrentChar()) {
            case 'd': {
                result = new DigitInput();
                break;
            }
            case 'D': {
                result = new DigitInput();
                result.setComplement(true);
                break;
            }
            case 'f': {
                result = new CharacterInput('\f');
                break;
            }
            case 'n': {
                result = new CharacterInput('\n');
                break;
            }
            case 'r': {
                result = new CharacterInput('\r');
                break;
            }
            case 's': {
                result = new WhiteSpaceInput();
                break;
            }
            case 'S': {
                result = new WhiteSpaceInput();
                result.setComplement(true);
                break;
            }
            case 't': {
                result = new CharacterInput('\t');
                break;
            }
            case 'v': {
                result = new CharacterInput('\u000b');
                break;
            }
            case 'w': {
                result = new WordInput();
                break;
            }
            case 'W': {
                result = new WordInput();
                result.setComplement(true);
                break;
            }
            case 'x': {
                int hi = 0;
                int lo = 0;
                ++this._index;
                if (this.isHexDigit()) {
                    hi = Character.digit(this.getCurrentChar(), 16);
                    ++this._index;
                    if (!this.isHexDigit()) {
                        throw new IllegalStateException(Messages.RegexParser_Malformed_Hex);
                    }
                } else {
                    throw new IllegalStateException(Messages.RegexParser_Malformed_Hex);
                }
                lo = Character.digit(this.getCurrentChar(), 16);
                result = new CharacterInput((char)(hi * 16 + lo));
            }
            default: {
                result = new CharacterInput(this.getCurrentChar());
            }
        }
        this.advance();
        return result;
    }

    private boolean parseSubExpression() {
        boolean success = true;
        this.advance();
        if (this.parseOrExpression()) {
            if (this.getCurrentChar() == ')') {
                this.advance();
            } else {
                success = false;
            }
        } else {
            success = false;
        }
        return success;
    }

    public void reset() {
        NFAGraph.reset();
        this._nfaStack.clear();
    }
}

