/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.regex.dfa;

import com.aptana.ide.regex.IRegexRunnerNode;
import com.aptana.ide.regex.dfa.DFAGraph;
import com.aptana.ide.regex.sets.NumberSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DFANode
implements IRegexRunnerNode {
    private NumberSet _transitionSet;
    private int[] _allTransitions;
    private int _acceptState;
    private int _group;

    public void setAcceptState(int state) {
        this._acceptState = state;
    }

    public int getGroup() {
        return this._group;
    }

    public void setGroup(int group) {
        this._group = group;
    }

    public void setItem(int index, int value) {
        this._allTransitions[index] = value;
    }

    public NumberSet getTransitionSet() {
        return this._transitionSet;
    }

    DFANode() {
        this._transitionSet = null;
        this._allTransitions = new int[0];
        this._acceptState = -1;
    }

    public DFANode(NumberSet inputs) {
        this._transitionSet = inputs;
        this._allTransitions = new int[256];
        this._acceptState = -1;
        int i = 0;
        while (i < 256) {
            this._allTransitions[i] = -1;
            ++i;
        }
    }

    public boolean inSamePartition(DFAGraph parent, DFANode testState) {
        boolean result;
        int transitionSize = parent._transitionSet.getSize();
        boolean bl = result = this.getAcceptState() == testState.getAcceptState();
        if (result) {
            int j = 0;
            while (j < transitionSize) {
                int testStateNext;
                int stateNext = this.getItem(j);
                if (stateNext != (testStateNext = testState.getItem(j))) {
                    int testStateNextGroup;
                    int stateNextGroup = stateNext == -1 ? -1 : ((DFANode)parent.getItem(stateNext)).getGroup();
                    int n = testStateNextGroup = testStateNext == -1 ? -1 : ((DFANode)parent.getItem(testStateNext)).getGroup();
                    if (stateNextGroup != testStateNextGroup) {
                        result = false;
                        break;
                    }
                }
                ++j;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._allTransitions.length) {
            int value = this._allTransitions[i];
            if (value == -1) {
                sb.append("-");
            } else {
                sb.append(value);
            }
            sb.append(" ");
            ++i;
        }
        sb.append(" : ").append(this.getAcceptState());
        return sb.toString();
    }

    public int getAcceptState() {
        return this._acceptState;
    }

    public int getItem(int index) {
        return this._allTransitions[index];
    }

    public void read(DataInput input) throws IOException {
        int transitionCount = input.readInt();
        this._allTransitions = new int[transitionCount];
        int i = 0;
        while (i < transitionCount) {
            this._allTransitions[i] = input.readInt();
            ++i;
        }
        this._acceptState = input.readInt();
    }

    public void write(DataOutput output) throws IOException {
        int transitionCount = this._allTransitions.length;
        output.writeInt(transitionCount);
        int i = 0;
        while (i < transitionCount) {
            output.writeInt(this._allTransitions[i]);
            ++i;
        }
        output.writeInt(this._acceptState);
    }
}

