/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.sax;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AttributeSniffer
extends DefaultHandler {
    private String targetElement;
    private String targetAttribute;
    private String matchedValue;

    public AttributeSniffer(String elementName, String attributeName) {
        this.targetAttribute = attributeName;
        this.targetElement = elementName;
    }

    public void read(String filename) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream fi = new FileInputStream(filename);
        this.read(fi);
        fi.close();
    }

    public void read(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)this);
        in.close();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals(this.targetElement) && attributes.getValue(this.targetAttribute) != null) {
            this.matchedValue = attributes.getValue(this.targetAttribute);
        }
    }

    public String getMatchedValue() {
        return this.matchedValue;
    }
}

