/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.sax;

import com.aptana.ide.io.SourceWriter;
import com.aptana.sax.InvalidTransitionException;
import com.aptana.sax.Messages;
import com.aptana.sax.SchemaElement;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    private Map<String, SchemaElement> _elementsByName;
    private SchemaElement _rootElement;
    private Stack<SchemaElement> _elementStack;
    private SchemaElement _currentElement;
    private Object _handler;
    private Class<?> _handlerClass;

    public Class<?> getHandlerClass() {
        return this._handlerClass;
    }

    public SchemaElement getRootElement() {
        return this._rootElement;
    }

    public boolean hasElement(String name) {
        return this._elementsByName.containsKey(name);
    }

    public void setRootElement(String name) {
        SchemaElement target = this.hasElement(name) ? this._elementsByName.get(name) : this.createElement(name);
        this._rootElement.addTransition(target);
    }

    public Schema(Object handler) {
        this._handler = handler;
        if (handler != null) {
            this._handlerClass = handler.getClass();
        }
        this._elementsByName = new HashMap<String, SchemaElement>();
        this._elementStack = new Stack();
        this._rootElement = new SchemaElement(this, "#document");
    }

    public SchemaElement createElement(String name) {
        return this.createElement(name, true);
    }

    public SchemaElement createElement(String name, boolean unique) {
        SchemaElement result = null;
        if (unique) {
            if (this.hasElement(name)) {
                result = this._elementsByName.get(name);
            } else {
                result = new SchemaElement(this, name);
                this._elementsByName.put(name, result);
            }
        } else {
            result = new SchemaElement(this, name);
        }
        return result;
    }

    public void moveTo(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws InvalidTransitionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SAXException {
        if (!this._currentElement.isValidTransition(localName)) {
            Object[] messageArgs = new Object[]{localName, this._currentElement.getName()};
            String message = MessageFormat.format(Messages.Schema_Invalid_Child, messageArgs);
            SourceWriter writer = new SourceWriter();
            writer.println();
            writer.println(message);
            this.buildErrorMessage(writer, localName, attributes);
            throw new InvalidTransitionException(writer.toString());
        }
        this._elementStack.push(this._currentElement);
        this._currentElement = this._currentElement.moveTo(localName);
        this._currentElement.validateAttributes(attributes);
        if (this._handler != null && this._currentElement.hasOnEnterMethod()) {
            this._currentElement.getOnEnterMethod().invoke(this._handler, namespaceURI, localName, qualifiedName, attributes);
        }
    }

    public void buildErrorMessage(SourceWriter writer, String localName, Attributes attributes) {
        SchemaElement element;
        writer.println().println(Messages.Schema_Element_Stack_Trace);
        int i = 0;
        while (i < Messages.Schema_Element_Stack_Trace.length()) {
            writer.print("=");
            ++i;
        }
        writer.println();
        i = 1;
        while (i < this._elementStack.size()) {
            element = (SchemaElement)this._elementStack.get(i);
            writer.printlnWithIndent(element.toString()).increaseIndent();
            ++i;
        }
        if (!localName.equals(this._currentElement.getName())) {
            writer.printlnWithIndent(this._currentElement.toString()).increaseIndent();
        }
        writer.printWithIndent("<").print(localName);
        i = 0;
        while (i < attributes.getLength()) {
            writer.print(" ").print(attributes.getLocalName(i)).print("=\"").print(attributes.getValue(i)).print("\"");
            ++i;
        }
        writer.println("/>");
        if (!localName.equals(this._currentElement.getName())) {
            writer.decreaseIndent().printWithIndent("</").print(this._currentElement.getName()).println(">");
        }
        i = this._elementStack.size() - 1;
        while (i > 0) {
            element = (SchemaElement)this._elementStack.get(i);
            writer.decreaseIndent().printWithIndent("</").print(element.getName()).println(">");
            --i;
        }
    }

    public void exitElement(String namespaceURI, String localName, String qualifiedName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this._handler != null && this._currentElement.hasOnExitMethod()) {
            this._currentElement.getOnExitMethod().invoke(this._handler, namespaceURI, localName, qualifiedName);
        }
        this._currentElement = this._elementStack.pop();
    }

    public void reset() {
        if (this._rootElement == null) {
            throw new IllegalStateException(Messages.Schema_Missing_Root_Element);
        }
        this._elementStack.clear();
        this._currentElement = this._rootElement;
    }
}

