/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.sax;

import com.aptana.sax.InvalidTransitionException;
import com.aptana.sax.Messages;
import com.aptana.sax.Schema;
import com.aptana.sax.SchemaElement;
import com.aptana.sax.SchemaInitializationException;
import com.aptana.sax.ValidatingReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class SchemaBuilder
extends ValidatingReader {
    private static final String USAGE_ATTRIBUTE = "usage";
    private static final String HAS_TEXT_ATTRIBUTE = "hasText";
    private static final String ON_EXIT_ATTRIBUTE = "onExit";
    private static final String ON_ENTER_ATTRIBUTE = "onEnter";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String USE_ELEMENT_SET_ELEMENT = "use-element-set";
    private static final String ELEMENT_SET_ELEMENT = "element-set";
    private static final String SETS_ELEMENT = "sets";
    private static final String CHILD_ELEMENT_ELEMENT = "child-element";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private static final String OPTIONAL = "optional";
    private static final String REQUIRED = "required";
    private static final String ELEMENT_ELEMENT = "element";
    private static final String SCHEMA_ELEMENT = "schema";
    private static String SCHEMA_1_0_NAMESPACE = "http://www.aptana.com/2005/schema/1.0";
    private static String SCHEMA_1_1_NAMESPACE = "http://www.aptana.com/2007/schema/1.1";
    private static SchemaBuilder _builder = null;
    private Schema _newSchema;
    private Stack<SchemaElement> _elementStack = new Stack();
    private SchemaElement _currentElement;
    private String _currentSetId;
    private Map<String, SchemaElement> _sets = new HashMap<String, SchemaElement>();
    private Schema _versionSelectorSchema;
    private Schema _schema10;
    private Schema _schema11;

    private SchemaBuilder() throws SchemaInitializationException {
        try {
            this.buildSchemaSchemas();
        }
        catch (SecurityException e) {
            String msg = Messages.SchemaBuilder_Insufficient_Reflection_Security;
            SchemaInitializationException ie = new SchemaInitializationException(msg, e);
            throw ie;
        }
        catch (NoSuchMethodException e) {
            String msg = Messages.SchemaBuilder_Missing_Handler_Method;
            SchemaInitializationException ie = new SchemaInitializationException(msg, e);
            throw ie;
        }
    }

    private void buildSchemaSchemas() throws SecurityException, NoSuchMethodException {
        this._schema10 = this.buildSchema10Schema();
        this._schema11 = this.buildSchema11Schema();
        this._versionSelectorSchema = this.buildVersionSelectorSchema();
    }

    private Schema buildVersionSelectorSchema() throws SecurityException, NoSuchMethodException {
        Schema result = new Schema(this);
        SchemaElement root = result.createElement(SCHEMA_ELEMENT);
        result.setRootElement(SCHEMA_ELEMENT);
        root.setOnEnter("startSchemaElement");
        return result;
    }

    private Schema buildSchema10Schema() throws SecurityException, NoSuchMethodException {
        Schema result = new Schema(this);
        SchemaElement root = result.createElement(SCHEMA_ELEMENT);
        result.setRootElement(SCHEMA_ELEMENT);
        SchemaElement element = result.createElement(ELEMENT_ELEMENT);
        root.addTransition(element);
        element.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        element.addAttribute(TYPE_ATTRIBUTE, OPTIONAL);
        element.addAttribute(ON_ENTER_ATTRIBUTE, OPTIONAL);
        element.addAttribute(ON_EXIT_ATTRIBUTE, OPTIONAL);
        element.addAttribute(HAS_TEXT_ATTRIBUTE, OPTIONAL);
        element.setOnEnter("startElementElement");
        element.setOnExit("exitElementElement");
        SchemaElement attribute = result.createElement(ATTRIBUTE_ELEMENT);
        element.addTransition(attribute);
        attribute.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        attribute.addAttribute(USAGE_ATTRIBUTE, OPTIONAL);
        attribute.setOnEnter("startAttributeElement");
        SchemaElement childElement = result.createElement(CHILD_ELEMENT_ELEMENT);
        element.addTransition(childElement);
        childElement.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        childElement.setOnEnter("startChildElementElement");
        return result;
    }

    private Schema buildSchema11Schema() throws SecurityException, NoSuchMethodException {
        Schema result = new Schema(this);
        SchemaElement root = result.createElement(SCHEMA_ELEMENT);
        result.setRootElement(SCHEMA_ELEMENT);
        SchemaElement element = result.createElement(ELEMENT_ELEMENT);
        root.addTransition(element);
        element.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        element.addAttribute(ON_ENTER_ATTRIBUTE, OPTIONAL);
        element.addAttribute(ON_EXIT_ATTRIBUTE, OPTIONAL);
        element.addAttribute(HAS_TEXT_ATTRIBUTE, OPTIONAL);
        element.setOnEnter("startElementElement");
        element.setOnExit("exitElementElement");
        element.addTransition(element);
        SchemaElement attribute = result.createElement(ATTRIBUTE_ELEMENT);
        element.addTransition(attribute);
        attribute.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        attribute.addAttribute(USAGE_ATTRIBUTE, OPTIONAL);
        attribute.setOnEnter("startAttributeElement");
        SchemaElement sets = result.createElement(SETS_ELEMENT);
        root.addTransition(sets);
        SchemaElement elementSet = result.createElement(ELEMENT_SET_ELEMENT);
        sets.addTransition(elementSet);
        elementSet.addAttribute("id", REQUIRED);
        elementSet.setOnEnter("startElementSetElement");
        elementSet.setOnExit("exitElementSetElement");
        elementSet.addTransition(element);
        SchemaElement useElementSet = result.createElement(USE_ELEMENT_SET_ELEMENT);
        root.addTransition(useElementSet);
        element.addTransition(useElementSet);
        elementSet.addTransition(useElementSet);
        useElementSet.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        useElementSet.setOnEnter("startUseElementSetElement");
        return result;
    }

    public void exitElementElement(String namespaceURI, String localName, String qualifiedName) {
        this._currentElement = this._elementStack.pop();
    }

    public void exitElementSetElement(String namespaceURI, String localName, String qualifiedName) {
        this._sets.put(this._currentSetId, this._currentElement);
        this._currentSetId = null;
        this._currentElement = this._elementStack.pop();
    }

    public static Schema fromXML(String filename, Object handler) throws SchemaInitializationException {
        FileInputStream fi = null;
        Schema schema = null;
        try {
            try {
                fi = new FileInputStream(filename);
                schema = SchemaBuilder.fromXML(fi, handler);
            }
            catch (FileNotFoundException e) {
                String msg = String.valueOf(Messages.SchemaBuilder_File_Unlocatable) + filename;
                SchemaInitializationException ie = new SchemaInitializationException(msg, e);
                throw ie;
            }
        }
        catch (Throwable throwable) {
            try {
                fi.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fi.close();
        }
        catch (IOException iOException) {}
        return schema;
    }

    public static Schema fromXML(InputStream in, Object handler) throws SchemaInitializationException {
        Schema result = new Schema(handler);
        if (_builder == null) {
            _builder = new SchemaBuilder();
        }
        SchemaBuilder._builder._schema = SchemaBuilder._builder._versionSelectorSchema;
        SchemaBuilder._builder._schema.reset();
        SchemaBuilder._builder._newSchema = result;
        try {
            _builder.read(in);
        }
        catch (ParserConfigurationException e) {
            String msg = Messages.SchemaBuilder_SAX_Parser_Initialization_Error;
            SchemaInitializationException ie = new SchemaInitializationException(msg, e);
            throw ie;
        }
        catch (SAXException e) {
            String msg = Messages.SchemaBuilder_SAX_Parser_Error;
            SchemaInitializationException ie = new SchemaInitializationException(msg, e);
            throw ie;
        }
        catch (IOException e) {
            String msg = Messages.SchemaBuilder_IO_Error;
            SchemaInitializationException ie = new SchemaInitializationException(msg, e);
            throw ie;
        }
        return result;
    }

    public void startAttributeElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        String name = attributes.getValue(NAME_ATTRIBUTE);
        String usage = attributes.getValue(USAGE_ATTRIBUTE);
        this._currentElement.addAttribute(name, usage);
    }

    public void startChildElementElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        String elementName = attributes.getValue(NAME_ATTRIBUTE);
        SchemaElement element = this._newSchema.createElement(elementName);
        this._currentElement.addTransition(element);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this._elementStack.clear();
        this._currentElement = this._newSchema.getRootElement();
    }

    public void startElementElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        String elementName = attributes.getValue(NAME_ATTRIBUTE);
        String elementType = attributes.getValue(TYPE_ATTRIBUTE);
        String onEnter = attributes.getValue(ON_ENTER_ATTRIBUTE);
        String onExit = attributes.getValue(ON_EXIT_ATTRIBUTE);
        String hasText = attributes.getValue(HAS_TEXT_ATTRIBUTE);
        SchemaElement element = this._newSchema.createElement(elementName);
        if (SCHEMA_1_0_NAMESPACE.equals(namespaceURI)) {
            if (elementType != null && elementType.equals("root")) {
                this._currentElement.addTransition(element);
            }
        } else {
            this._currentElement.addTransition(element);
        }
        if (onEnter != null && onEnter.length() > 0) {
            try {
                element.setOnEnter(onEnter);
            }
            catch (SecurityException e) {
                String message = String.valueOf(Messages.SchemaBuilder_Unable_To_Get_OnEnter_Method) + onEnter;
                throw new SAXException(message, e);
            }
            catch (NoSuchMethodException e) {
                String message = String.valueOf(Messages.SchemaBuilder_Unable_To_Locate_OnEnter_Method) + onEnter;
                throw new SAXException(message, e);
            }
        }
        if (onExit != null && onExit.length() > 0) {
            try {
                element.setOnExit(onExit);
            }
            catch (SecurityException e) {
                String message = String.valueOf(Messages.SchemaBuilder_Unable_To_Get_OnExit_Method) + onExit;
                throw new SAXException(message, e);
            }
            catch (NoSuchMethodException e) {
                String message = String.valueOf(Messages.SchemaBuilder_Unable_To_Locate_OnExit_Method) + onExit;
                throw new SAXException(message, e);
            }
        }
        if (hasText != null && hasText.length() > 0) {
            String lowerHasText = hasText.toLowerCase();
            boolean hasTextValue = lowerHasText.equals("true") || lowerHasText.equals("yes");
            element.setHasText(hasTextValue);
        }
        this._elementStack.push(this._currentElement);
        this._currentElement = element;
    }

    public void startElementSetElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        String id;
        SchemaElement set = this._newSchema.createElement(localName, false);
        this._currentSetId = id = attributes.getValue("id");
        this._elementStack.push(this._currentElement);
        this._currentElement = set;
    }

    public void startSchemaElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (SCHEMA_1_0_NAMESPACE.equals(namespaceURI)) {
            this._schema = this._schema10;
        } else if (SCHEMA_1_1_NAMESPACE.equals(namespaceURI)) {
            this._schema = this._schema11;
        } else {
            String message = String.valueOf(Messages.SchemaBuilder_Unknown_Schema_Namespace) + namespaceURI;
            throw new SAXException(message);
        }
        try {
            this._schema.reset();
            this._schema.moveTo(namespaceURI, localName, qualifiedName, attributes);
        }
        catch (IllegalArgumentException e) {
            throw new SAXException(e);
        }
        catch (InvalidTransitionException e) {
            throw new SAXException(e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException(e);
        }
        catch (InvocationTargetException e) {
            throw new SAXException(e);
        }
    }

    public void startUseElementSetElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        String name = attributes.getValue(NAME_ATTRIBUTE);
        String id = name.substring(1);
        this.addSetToElement(id, this._currentElement);
    }

    private void addSetToElement(String id, SchemaElement element) {
        if (this._sets.containsKey(id)) {
            SchemaElement set = this._sets.get(id);
            SchemaElement[] children = set.getTransitionElements();
            int i = 0;
            while (i < children.length) {
                SchemaElement child = children[i];
                this._currentElement.addTransition(child);
                ++i;
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(Messages.SchemaBuilder_Set_ID_Not_Defined) + id);
        }
    }
}

