/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.sax;

import com.aptana.ide.io.SourceWriter;
import com.aptana.sax.Messages;
import com.aptana.sax.Schema;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SchemaElement {
    private static final Class<?>[] enterSignature = new Class[]{String.class, String.class, String.class, Attributes.class};
    private static final Class<?>[] exitSignature = new Class[]{String.class, String.class, String.class};
    private String _name;
    private Schema _owningSchema;
    private Map<String, SchemaElement> _transitions;
    private Map<String, Integer> _attributes;
    private List<String> _requiredAttributes;
    private String _instanceAttributes;
    private Method _onEnter;
    private Method _onExit;
    private boolean _hasText;

    public SchemaElement(Schema owningSchema, String name) {
        if (owningSchema == null) {
            throw new IllegalArgumentException(Messages.SchemaElement_Undefined_Owning_Schema);
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(Messages.SchemaElement_Undefined_Name);
        }
        this._owningSchema = owningSchema;
        this._name = name;
        this._transitions = new HashMap<String, SchemaElement>();
        this._attributes = new HashMap<String, Integer>();
        this._requiredAttributes = new ArrayList<String>();
    }

    public String getName() {
        return this._name;
    }

    public Method getOnEnterMethod() {
        return this._onEnter;
    }

    public void setHasText(boolean value) {
        this._hasText = value;
    }

    public void setOnEnter(String onEnterMethod) throws SecurityException, NoSuchMethodException {
        Class<?> handlerClass = this._owningSchema.getHandlerClass();
        this._onEnter = handlerClass != null ? handlerClass.getMethod(onEnterMethod, enterSignature) : null;
    }

    public Method getOnExitMethod() {
        return this._onExit;
    }

    public void setOnExit(String onExitMethod) throws SecurityException, NoSuchMethodException {
        Class<?> handlerClass = this._owningSchema.getHandlerClass();
        this._onExit = handlerClass != null ? handlerClass.getMethod(onExitMethod, exitSignature) : null;
    }

    public SchemaElement[] getTransitionElements() {
        Collection<SchemaElement> values = this._transitions.values();
        return values.toArray(new SchemaElement[values.size()]);
    }

    public boolean hasAttribute(String name) {
        return this._attributes.containsKey(name);
    }

    public boolean hasOnEnterMethod() {
        return this._onEnter != null;
    }

    public boolean hasOnExitMethod() {
        return this._onExit != null;
    }

    public boolean hasText() {
        return this._hasText;
    }

    public boolean hasTransitions() {
        return this._transitions.size() > 0;
    }

    public boolean isDeprecatedAttribute(String name) {
        boolean result = false;
        if (this.isValidAttribute(name)) {
            int flags = this._attributes.get(name);
            result = (flags & 4) == 4;
        }
        return result;
    }

    public boolean isOptionalAttribute(String name) {
        boolean result = false;
        if (this.isValidAttribute(name)) {
            int flags = this._attributes.get(name);
            result = (flags & 3) == 2;
        }
        return result;
    }

    public boolean isRequiredAttribute(String name) {
        boolean result = false;
        if (this.isValidAttribute(name)) {
            int flags = this._attributes.get(name);
            result = (flags & 3) == 1;
        }
        return result;
    }

    public boolean isValidAttribute(String name) {
        return this._attributes.containsKey(name);
    }

    public boolean isValidTransition(String name) {
        return this._transitions.containsKey(name);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addAttribute(String name, String usage) {
        int usageValue;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(Messages.SchemaElement_Undefined_Name);
        }
        if (this.hasAttribute(name)) {
            String msg = "The attribute '" + name + "' has already been defined on " + this._name;
            throw new IllegalArgumentException(msg);
        }
        if (usage != null) {
            if (usage.equals("required")) {
                usageValue = 1;
            } else {
                if (!usage.equals("optional")) {
                    String msg = String.valueOf(usage) + " is not a valid 'usage' attribute value. <attribute>'s usage attribute must equal 'required' or 'optional'";
                    throw new IllegalArgumentException(msg);
                }
                usageValue = 2;
            }
        } else {
            usageValue = 1;
        }
        this._attributes.put(name, new Integer(usageValue));
        if ((usageValue & 3) == 1) {
            this._requiredAttributes.add(name);
        }
    }

    public void addTransition(SchemaElement node) {
        if (node == null) {
            throw new IllegalArgumentException(Messages.SchemaElement_Undefined_Node);
        }
        String nodeName = node.getName();
        if (this.isValidTransition(nodeName)) {
            String msg = "A node name '" + nodeName + "' has already been added to " + this._name;
            throw new IllegalArgumentException(msg);
        }
        this._transitions.put(nodeName, node);
    }

    public SchemaElement moveTo(String name) {
        return this._transitions.get(name);
    }

    public void validateAttributes(Attributes attributes) throws SAXException {
        String name;
        String value;
        int i;
        if (attributes.getLength() > 0) {
            this._instanceAttributes = "";
            i = 0;
            while (i < attributes.getLength()) {
                String key = attributes.getLocalName(i);
                value = attributes.getValue(i);
                this._instanceAttributes = String.valueOf(this._instanceAttributes) + " " + key + "=\"" + value + "\"";
                ++i;
            }
        }
        i = 0;
        while (i < this._requiredAttributes.size()) {
            name = this._requiredAttributes.get(i);
            value = attributes.getValue(name);
            if (value == null) {
                SourceWriter writer = new SourceWriter();
                writer.print("<").print(this._name).print("> requires a '").print(name).println("' attribute");
                this._owningSchema.buildErrorMessage(writer, this._name, attributes);
                throw new SAXException(writer.toString());
            }
            ++i;
        }
        i = 0;
        while (i < attributes.getLength()) {
            name = attributes.getLocalName(i);
            if (!this._attributes.containsKey(name)) {
                SourceWriter writer = new SourceWriter();
                writer.print("Invalid attribute '").print(name).print("' on <").print(this._name).println(">");
                this._owningSchema.buildErrorMessage(writer, this._name, attributes);
                throw new SAXException(writer.toString());
            }
            ++i;
        }
    }

    public String toString() {
        String result = "<" + this._name;
        if (this._instanceAttributes != null) {
            result = String.valueOf(result) + this._instanceAttributes;
        }
        result = this.hasTransitions() ? String.valueOf(result) + ">" : String.valueOf(result) + "/>";
        return result;
    }
}

