/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.sax;

import com.aptana.sax.InvalidTransitionException;
import com.aptana.sax.Schema;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatingReader
extends DefaultHandler {
    protected Schema _schema;

    protected ValidatingReader() {
        this(null);
    }

    public ValidatingReader(Schema schema) {
        if (schema == null) {
            schema = new Schema(this);
        }
        this._schema = schema;
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this._schema != null) {
            try {
                this._schema.exitElement(namespaceURI, localName, qualifiedName);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e);
            }
            catch (IllegalAccessException e) {
                throw new SAXException(e);
            }
            catch (InvocationTargetException e) {
                throw new SAXException(e);
            }
        }
    }

    public void read(String filename) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream fi = new FileInputStream(filename);
        this.read(fi);
        fi.close();
    }

    public void read(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)this);
        in.close();
    }

    public void startDocument() throws SAXException {
        if (this._schema != null) {
            this._schema.reset();
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this._schema != null) {
            try {
                this._schema.moveTo(namespaceURI, localName, qualifiedName, attributes);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(e);
            }
            catch (InvalidTransitionException e) {
                throw new SAXException(e);
            }
            catch (IllegalAccessException e) {
                throw new SAXException(e);
            }
            catch (InvocationTargetException e) {
                Throwable innerException = e.getCause();
                if (innerException instanceof SAXException) {
                    throw (SAXException)innerException;
                }
                throw new SAXException(e);
            }
        }
    }
}

