/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.xml;

import com.aptana.xml.DocumentNode;
import com.aptana.xml.INode;
import com.aptana.xml.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBase
implements INode,
Comparable<NodeBase> {
    protected static final String EMPTY_STRING = "";
    private List<Class<?>> childTypes;
    private INode _parent;
    private List<INode> _children;
    private int _childCount;
    private StringBuffer _text;
    private int _columnNumber;
    private int _lineNumber;

    public void addChildType(Class<?> type) {
        if (this.childTypes == null) {
            this.childTypes = new ArrayList();
        }
        if (!this.childTypes.contains(type)) {
            this.childTypes.add(type);
        }
    }

    @Override
    public void appendChild(INode child) {
        boolean allowed = false;
        if (this.childTypes != null) {
            int i = 0;
            while (i < this.childTypes.size()) {
                Class<?> type = this.childTypes.get(i);
                if (type.isInstance(child)) {
                    allowed = true;
                    break;
                }
                ++i;
            }
        }
        if (allowed) {
            if (this._children == null) {
                this._children = new ArrayList<INode>();
            }
            this._children.add(child);
            ++this._childCount;
            if (child instanceof NodeBase) {
                ((NodeBase)child).setParent(this);
            }
        } else {
            String thisName = this.getClass().getName();
            String childName = child.getClass().getName();
            String message = MessageFormat.format(Messages.NodeBase_Invalid_Child_Type, thisName, childName);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void appendText(String text) {
        if (text != null && text.length() > 0) {
            if (this._text == null) {
                this._text = new StringBuffer();
            }
            this._text.append(text);
        }
    }

    @Override
    public INode getChild(int index) {
        INode result = null;
        if (this._children != null && index >= 0 && index < this._childCount) {
            result = this._children.get(index);
        }
        return result;
    }

    @Override
    public int getChildCount() {
        return this._childCount;
    }

    @Override
    public DocumentNode getDocument() {
        INode result = this.getParent();
        while (result != null && !(result instanceof DocumentNode)) {
            result = result.getParent();
        }
        if (result == null) {
            result = new DocumentNode();
        }
        return (DocumentNode)result;
    }

    @Override
    public INode getParent() {
        return this._parent;
    }

    @Override
    public String getText() {
        String result = EMPTY_STRING;
        if (this._text != null) {
            result = this._text.toString();
        }
        return result;
    }

    @Override
    public void removeChild(INode child) {
        if (this._children != null) {
            if (this._children.remove(child)) {
                --this._childCount;
            }
            if (child instanceof NodeBase) {
                ((NodeBase)child)._parent = null;
            }
        }
    }

    public void removeChildType(Class<?> type) {
        if (this.childTypes != null) {
            this.childTypes.remove(type);
        }
    }

    public void removeText() {
        this._text = null;
    }

    protected void setParent(INode parent) {
        if (this._parent != null) {
            this._parent.removeChild(this);
        }
        this._parent = parent;
    }

    @Override
    public int getColumnNumber() {
        return this._columnNumber;
    }

    @Override
    public void setColumnNumber(int columnNumber) {
        this._columnNumber = columnNumber;
    }

    @Override
    public int getLineNumber() {
        return this._lineNumber;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this._lineNumber = lineNumber;
    }

    @Override
    public int compareTo(NodeBase that) {
        int result = this.getLineNumber() - that.getLineNumber();
        if (result == 0) {
            result = this.getColumnNumber() - that.getColumnNumber();
        }
        return result;
    }
}

