/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging;

import com.aptana.ide.core.BaseFileEditorInput;
import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.Messages;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.coloring.LoggingColorizer;
import com.aptana.ide.logging.coloring.LoggingLexemeManager;
import com.aptana.ide.logging.coloring.TokenTypes;
import com.aptana.ide.logging.preferences.ILoggingPreferenceListener;
import java.io.File;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class LogReadonlyEditor
extends TextEditor {
    private LineStyleListener _lineStyleListener;
    private LoggingColorizer _colorizer;
    protected LoggingLexemeManager lexememanager;
    protected int _maxColorizingColumns = 512;
    private Composite composite;
    protected SourceViewerDecorationSupport decorationSupport;
    private Color textForeground;
    private SourceViewer viewer;
    private ToolBar refreshBar;
    private ToolItem refreshItem;
    private IVirtualFile refreshableFile;
    private IPropertyChangeListener colorizationPreferencesListener;

    public boolean isEditable() {
        return false;
    }

    protected void firePropertyChange(int property) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof BaseFileEditorInput) {
            BaseFileEditorInput bfei = (BaseFileEditorInput)input;
            this.refreshableFile = bfei.getVirtualFile();
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return this.createViewer(parent, ruler);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.createColorizer();
        this.initializeColors();
        this.linkColorer();
    }

    private ISourceViewer createViewer(Composite parent, IVerticalRuler ruler) {
        int viewerStyle = 0;
        viewerStyle = LoggingPlugin.getDefault().getLoggingPreferences().getWrapping() ? 2624 : 2816;
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        GridData data = new GridData(4, 4, true, true);
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)data);
        this.composite.setBackground(UnifiedColorManager.getInstance().getColor(new RGB(220, 220, 220)));
        if (this.refreshableFile != null) {
            this.refreshBar = new ToolBar(this.composite, 0x800000);
            this.refreshBar.setBackground(UnifiedColorManager.getInstance().getColor(new RGB(220, 220, 220)));
            this.refreshBar.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
            this.refreshItem = new ToolItem(this.refreshBar, 8);
            this.refreshItem.setImage(LoggingPlugin.getImage("icons/active/refresh_active.gif"));
            this.refreshItem.setToolTipText("Refresh file contents");
            this.refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LogReadonlyEditor.this.refreshItem.setEnabled(false);
                    Job job = new Job("Refreshing log file"){

                        protected IStatus run(IProgressMonitor monitor) {
                            block6: {
                                File temp;
                                block5: {
                                    String newFileName = FileUtils.getRandomFileName((String)"temp", (String)".html");
                                    temp = new File(String.valueOf(FileUtils.systemTempDir) + File.separator + newFileName);
                                    temp.deleteOnExit();
                                    temp.getParentFile().mkdirs();
                                    try {
                                        try {
                                            LogReadonlyEditor.this.refreshableFile.getFileManager().putToLocalFile(LogReadonlyEditor.this.refreshableFile, temp);
                                        }
                                        catch (Exception e2) {
                                            CoreUIUtils.showError((String)StringUtils.format((String)Messages.FileExplorerView_UnableToSaveRemoteFile, (Object[])new String[]{LogReadonlyEditor.this.refreshableFile.getAbsolutePath(), temp.getAbsolutePath()}), (Exception)e2);
                                            break block5;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        UIJob update = new UIJob(this, "Updating log editor contents", temp){
                                            final /* synthetic */ 1 this$2;
                                            private final /* synthetic */ File val$temp;
                                            {
                                                this.this$2 = var1_1;
                                                this.val$temp = file;
                                                super($anonymous0);
                                            }

                                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                                try {
                                                    if (LogReadonlyEditor.access$1(1.access$0(1.access$0(this.this$2))) != null && LogReadonlyEditor.access$1(1.access$0(1.access$0(this.this$2))).getTextWidget() != null && !LogReadonlyEditor.access$1(1.access$0(1.access$0(this.this$2))).getTextWidget().isDisposed()) {
                                                        LogReadonlyEditor.access$0(1.access$0(1.access$0(this.this$2))).setEnabled(true);
                                                        LogReadonlyEditor.access$1(1.access$0(1.access$0(this.this$2))).getTextWidget().setText(FileUtils.readContent((File)this.val$temp));
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)"Error updating log editor contents");
                                                }
                                                catch (Error error) {
                                                    IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)"Error updating log editor contents");
                                                }
                                                return Status.OK_STATUS;
                                            }
                                        };
                                        update.schedule();
                                        throw throwable;
                                    }
                                    UIJob update = new /* invalid duplicate definition of identical inner class */;
                                    update.schedule();
                                    break block6;
                                }
                                UIJob update = new /* invalid duplicate definition of identical inner class */;
                                update.schedule();
                            }
                            return Status.OK_STATUS;
                        }

                        static /* synthetic */ 1 access$0(1 var0) {
                            return var0.this;
                        }
                    };
                    job.schedule();
                }
            });
        }
        this.viewer = new ReadOnlySourceViewer(this.composite, ruler, viewerStyle);
        this.viewer.addTextInputListener(new ITextInputListener(){

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            }

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                LogReadonlyEditor.this.lexememanager = new LoggingLexemeManager(newInput, LoggingPlugin.getDefault().getLoggingPreferences());
            }
        });
        Control control = this.viewer.getControl();
        control.setLayoutData((Object)data);
        this.viewer.getTextWidget().setFont(LoggingPlugin.getDefault().getLoggingPreferences().getFont());
        this.viewer.activatePlugins();
        this.createSourceViewerDecorationSupport((ISourceViewer)this.viewer);
        this.bindToColorizationSave();
        this.viewer.getTextWidget().addLineStyleListener(this._lineStyleListener);
        return this.viewer;
    }

    private void bindToColorizationSave() {
        this.colorizationPreferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("Colorization saved".equals(event.getProperty())) {
                    LogReadonlyEditor.this.createColorizer();
                    LogReadonlyEditor.this.lexememanager.clearCache();
                    if (LogReadonlyEditor.this.viewer != null) {
                        LogReadonlyEditor.this.viewer.setRedraw(false);
                        ISourceViewer sv = LogReadonlyEditor.this.getSourceViewer();
                        if (sv != null && sv.getTextWidget() != null) {
                            StyledText st = sv.getTextWidget();
                            st.removeLineStyleListener(LogReadonlyEditor.this._lineStyleListener);
                            st.addLineStyleListener(LogReadonlyEditor.this._lineStyleListener);
                        }
                        LogReadonlyEditor.this.viewer.setRedraw(true);
                    }
                }
            }
        };
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.colorizationPreferencesListener);
        LoggingPreferences preferences = LoggingPlugin.getDefault().getLoggingPreferences();
        ILoggingPreferenceListener loggingPreferenceListener = new ILoggingPreferenceListener(){

            public void rulesChanged() {
            }

            public void wrappingChanged(boolean wrapping) {
            }

            public void fontChanged(Font font) {
                if (LogReadonlyEditor.this.viewer != null && LogReadonlyEditor.this.viewer.getTextWidget() != null && !LogReadonlyEditor.this.viewer.getTextWidget().isDisposed()) {
                    LogReadonlyEditor.this.viewer.getTextWidget().setFont(font);
                }
            }

            public void textForegroundColorChanged(Color color) {
                LogReadonlyEditor.this.textForeground = color;
            }
        };
        preferences.addPreferenceListener(loggingPreferenceListener);
    }

    private void createColorizer() {
        this._colorizer = new LoggingColorizer(this.getLexer().getTokenList("text/log"));
    }

    private void linkColorer() {
        if (this._lineStyleListener == null) {
            this._lineStyleListener = new LineStyleListener(){

                public void lineGetStyle(LineStyleEvent e) {
                    int orgOffset;
                    if (LogReadonlyEditor.this.viewer == null || LogReadonlyEditor.this.viewer.getDocument() == null || LogReadonlyEditor.this.lexememanager == null) {
                        return;
                    }
                    int offset = orgOffset = e.lineOffset;
                    int extra = 0;
                    int lineLength = e.lineText.length();
                    if (LogReadonlyEditor.this.getSourceViewer() instanceof ITextViewerExtension5) {
                        ITextViewerExtension5 v5 = (ITextViewerExtension5)LogReadonlyEditor.this.getSourceViewer();
                        offset = v5.widgetOffset2ModelOffset(e.lineOffset);
                        extra = offset - e.lineOffset;
                    }
                    if (lineLength > LogReadonlyEditor.this._maxColorizingColumns) {
                        // empty if block
                    }
                    Lexeme[] lexemes = null;
                    try {
                        int lineNumber = LogReadonlyEditor.this.viewer.getDocument().getLineOfOffset(e.lineOffset);
                        lexemes = LogReadonlyEditor.this.lexememanager.getLexemes(lineNumber);
                    }
                    catch (BadLocationException e1) {
                        IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)"Unexpected exception", (Throwable)e1);
                    }
                    if (lexemes != null && lexemes.length > 0) {
                        Vector<StyleRange> styles = new Vector<StyleRange>();
                        LogReadonlyEditor.this._colorizer.createStyles(styles, lexemes, false);
                        StyleRange[] styleResults = styles.toArray(new StyleRange[0]);
                        if (extra > 0) {
                            int i = 0;
                            while (i < styleResults.length) {
                                StyleRange range = styleResults[i];
                                range.start -= extra;
                                ++i;
                            }
                        }
                        e.styles = styleResults;
                    } else {
                        StyleRange[] styles = new StyleRange[]{new StyleRange(e.lineOffset, e.lineText.length(), LogReadonlyEditor.this.textForeground, null)};
                        e.styles = styles;
                    }
                }
            };
        }
    }

    private void initializeColors() {
        this.textForeground = LoggingPlugin.getDefault().getLoggingPreferences().getTextColor();
    }

    protected void createSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.decorationSupport == null) {
            ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
            this.decorationSupport = new SourceViewerDecorationSupport(viewer, null, null, sharedColors);
            this.configureSourceViewerDecorationSupport(this.decorationSupport);
            this.decorationSupport.install(LoggingPlugin.getDefault().getPreferenceStore());
        }
    }

    public boolean isDirty() {
        return false;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCursorLinePainterPreferenceKeys("com.aptana.ide.logging.preferences.LoggingPreferences.cursorline", "com.aptana.ide.logging.preferences.LoggingPreferences.cursorlinecolor");
        support.setSymbolicFontName("com.aptana.ide.logging.preferences.LoggingPreferences.maintextfont");
    }

    private ILexer getLexer() {
        return TokenTypes.getLexerFactory().getLexer();
    }

    public void dispose() {
        super.dispose();
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.colorizationPreferencesListener);
    }

    class ReadOnlySourceViewer
    extends SourceViewer {
        public ReadOnlySourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
            super(parent, ruler, styles);
        }

        protected void createControl(Composite parent, int styles) {
            super.createControl(parent, styles | 8);
            this.getTextWidget().setEditable(false);
        }
    }
}

