/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.coloring;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.XMLUtils;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.IEnumerationMap;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.matcher.MatcherLexerBuilder;
import com.aptana.ide.lexer.matcher.MatcherTokenList;
import com.aptana.ide.lexer.matcher.OrMatcher;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.coloring.TokenTypes;
import com.aptana.ide.logging.impl.InLineMatcher;
import com.aptana.ide.logging.preferences.ILoggingPreferenceListener;
import com.aptana.xml.INode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class LoggingLexerFactory {
    private ILexer lexer;

    public ILexer getLexer() {
        if (this.lexer != null) {
            return this.lexer;
        }
        MatcherLexerBuilder builder = new MatcherLexerBuilder();
        String lexerXML = this.createColoringLexerXML();
        ByteArrayInputStream in = new ByteArrayInputStream(lexerXML.getBytes());
        builder.loadXML((InputStream)in, LoggingLexerFactory.class.getClassLoader());
        try {
            this.lexer = builder.buildLexer();
            MatcherTokenList tokenList = (MatcherTokenList)this.lexer.getTokenList("text/log");
            if (tokenList.hasGroup("default")) {
                tokenList.setCurrentGroup("default");
                OrMatcher topMatcher = tokenList.getCurrentMatcher();
                INode child = topMatcher.getChild(0);
                if (child instanceof InLineMatcher) {
                    InLineMatcher inLineMatcher = (InLineMatcher)child;
                    inLineMatcher.buildFirstCharacterMap();
                }
            }
            IEnumerationMap typeMap = tokenList.getTypeMap();
            this.lexer.setIgnoreSet("text/log", new int[]{typeMap.getIntValue("SYSTEM_ERROR_LEXEME")});
        }
        catch (LexerException e) {
            IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)"Unexpected exception", (Throwable)e);
        }
        return this.lexer;
    }

    LoggingLexerFactory() {
        LoggingPreferences preferences = LoggingPlugin.getDefault().getLoggingPreferences();
        preferences.addPreferenceListener(new ILoggingPreferenceListener(){

            public void rulesChanged() {
                LoggingLexerFactory.this.lexer = null;
            }

            public void wrappingChanged(boolean wrapping) {
            }

            public void fontChanged(Font font) {
            }

            public void textForegroundColorChanged(Color color) {
            }
        });
    }

    private String createColoringLexerXML() {
        SourceWriter writer = new SourceWriter();
        writer.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.println("<lexer").increaseIndent();
        writer.printlnWithIndent("xmlns=\"http://www.aptana.com/2007/lexer/1.2\"");
        writer.printlnWithIndent("language=\"text/log\"");
        writer.printlnWithIndent("category-enumeration=\"com.aptana.ide.logging.coloring.TokenCategories\"");
        writer.printlnWithIndent("type-enumeration=\"com.aptana.ide.logging.coloring.TokenTypes\">");
        writer.printlnWithIndent("<bundle>com.aptana.ide.logging</bundle>");
        writer.printlnWithIndent("<package>com.aptana.ide.logging.impl</package>");
        writer.printlnWithIndent("<token-group group=\"default\">").increaseIndent();
        this.emitRules(writer);
        writer.decreaseIndent().printlnWithIndent("</token-group>");
        writer.decreaseIndent().printlnWithIndent("</lexer>");
        return writer.toString();
    }

    private void emitRules(SourceWriter writer) {
        List<LoggingPreferences.Rule> rules = LoggingPlugin.getDefault().getLoggingPreferences().getRules();
        if (rules.size() > 0) {
            writer.printlnWithIndent("<category-group category=\"" + TokenTypes.DEFAULT_CATEGORY + "\">").increaseIndent();
            writer.printlnWithIndent("<in-line>").increaseIndent();
            for (LoggingPreferences.Rule rule : rules) {
                this.writeRule(writer, rule);
            }
            writer.printlnWithIndent("<regex category=\"" + TokenTypes.SYSTEM + "\" type=\"" + "SYSTEM_ERROR_LEXEME" + "\">.</regex>");
            writer.decreaseIndent().printlnWithIndent("</in-line>");
            writer.decreaseIndent().printlnWithIndent("</category-group>");
        }
    }

    private void writeRule(SourceWriter writer, LoggingPreferences.Rule rule) {
        String elementName = rule.isRegexp() ? "regex" : "string";
        String caseAttribute = rule.isCaseInsensitive() ? " case-insensitive=\"true\"" : "";
        String patternName = XMLUtils.entitize((String)rule.getName());
        String patternString = XMLUtils.entitize((String)rule.getRule());
        String element = MessageFormat.format("<{0} type=\"{1}\"{3}>{2}</{0}>", elementName, patternName, patternString, caseAttribute);
        writer.printlnWithIndent(element);
    }
}

