/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.logging.ILogResource;
import com.aptana.ide.logging.impl.AbstractLogResource;
import com.aptana.ide.logging.impl.AbstractLogWatcher;
import com.aptana.ide.logging.impl.LogWatcherConfiguration;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;

public abstract class LineBasedLogWatcher
extends AbstractLogWatcher {
    private static final int INCREASE_K = 2;
    private static final int MAX_ITERATIONS = 3;
    private static final float ACCEPTABLE_DIFFERENCE = 0.1f;
    private final int MEAN_CHARS_PER_LINE = 80;
    private final int MAX_BUFFER = 0x100000;
    private final int LINEAR_BORDER = 65536;
    private int _meanCharactersPerLine = 80;
    private CharBuffer _charBuffer;
    private ByteBuffer _primaryByteBuffer;
    private ByteBuffer _secondaryByteBuffer;
    private long _lastFileLength = 0L;
    private long _lastDocumentPosition = 0L;

    protected abstract long getCurrentLogLength() throws IOException;

    protected abstract void readData(int var1, ByteBuffer var2, int var3) throws IOException;

    public LineBasedLogWatcher(LogWatcherConfiguration config, ILogResource resource) {
        super(config, resource);
        int estimatedByteBufferSize = this.estimateByteBufferSize(config.getBacklogRows(), config.getEncoding());
        int estimatedCharBufferSize = this.estimateCharBufferSize(config.getBacklogRows());
        this._charBuffer = CharBuffer.allocate(estimatedCharBufferSize);
        this._primaryByteBuffer = ByteBuffer.allocate(estimatedByteBufferSize);
        this._secondaryByteBuffer = ByteBuffer.allocate(estimatedByteBufferSize);
    }

    protected AbstractLogWatcher.DataChange getData() throws IOException {
        long currentFileLength = this.getCurrentLogLength();
        if (currentFileLength == this._lastFileLength || currentFileLength == -1L) {
            return null;
        }
        if (currentFileLength < this._lastFileLength) {
            this.resetWatching();
        }
        long currentReadEndingPosition = currentFileLength;
        int linesToRead = this.getConfiguration().getBacklogRows();
        boolean documentAdditionMode = false;
        ChunkReadResult readResult = null;
        int iteration = 0;
        while (iteration < 3) {
            readResult = this.readChunk(currentReadEndingPosition, linesToRead);
            if (readResult.ioError) {
                return null;
            }
            documentAdditionMode = readResult.inputLimitReached;
            if (readResult.bufferLimitReached || readResult.inputLimitReached || this.acceptableNumberOfLines(readResult.lineCount.lines)) break;
            ++iteration;
        }
        if (readResult != null && readResult.lineCount != null && readResult.lineCount.lineOffsets.length == 0) {
            return null;
        }
        AbstractLogWatcher.DataChange result = null;
        if (this._lastFileLength == 0L || !documentAdditionMode) {
            String data = this._charBuffer.subSequence(0, this._charBuffer.limit()).toString();
            result = new AbstractLogWatcher.DataChange(data, 0, Integer.MAX_VALUE);
            this._lastDocumentPosition = data.length();
        } else {
            String data = this._charBuffer.toString();
            result = new AbstractLogWatcher.DataChange(data, (int)this._lastDocumentPosition, data.length());
            this._lastDocumentPosition += (long)data.length();
        }
        this._lastFileLength = currentFileLength;
        return result;
    }

    private boolean acceptableNumberOfLines(int lines) {
        int maxLines = this.getConfiguration().getBacklogRows();
        if (lines >= maxLines) {
            return true;
        }
        return (float)(maxLines - lines) < (float)maxLines * 0.1f;
    }

    private ChunkReadResult readChunk(long readEndPosition, int linesToRead) {
        long inputLimit;
        ChunkReadResult result = new ChunkReadResult();
        int bytesToRead = this.estimateByteBufferSize(linesToRead, this.getConfiguration().getEncoding());
        ByteBuffer byteBufferTarget = null;
        int maxCapacity = 0;
        if (this._primaryByteBuffer.position() == 0) {
            byteBufferTarget = this._primaryByteBuffer;
            maxCapacity = this.ensureByteBufferCapacity(bytesToRead);
        } else {
            byteBufferTarget = this._secondaryByteBuffer;
            int oldMainBufferCapacity = this._primaryByteBuffer.capacity();
            int maxMainBufferCapacity = this.ensureSecondaryByteBufferCapacity(oldMainBufferCapacity + bytesToRead);
            int allowedSecondaryBufferCapacity = maxMainBufferCapacity - oldMainBufferCapacity;
            maxCapacity = this.ensureSecondaryByteBufferCapacity(allowedSecondaryBufferCapacity);
        }
        if (maxCapacity < bytesToRead) {
            bytesToRead = maxCapacity;
            result.bufferLimitReached = true;
        }
        if ((inputLimit = readEndPosition - this._lastFileLength) < (long)bytesToRead) {
            result.inputLimitReached = true;
            bytesToRead = (int)inputLimit;
        }
        if (inputLimit == 0L) {
            return result;
        }
        int startPos = (int)(readEndPosition - (long)bytesToRead);
        byteBufferTarget.clear();
        try {
            this.readData(startPos, byteBufferTarget, bytesToRead);
        }
        catch (IOException iOException) {
            result.ioError = true;
            return result;
        }
        if (byteBufferTarget == this._secondaryByteBuffer) {
            this.addSecondaryByteBufferToPrimary();
        }
        this.decodeBytes();
        result.lineCount = this.countNumberOfLines(this._charBuffer);
        return result;
    }

    private void decodeBytes() {
        int charBufferCapacityEstimation = (int)((float)this._primaryByteBuffer.limit() * this.getConfiguration().getEncoding().newDecoder().averageCharsPerByte()) + 1024;
        this.ensureCharBufferCapacity(charBufferCapacityEstimation);
        this._charBuffer.clear();
        this.getConfiguration().getEncoding().newDecoder().decode(this._primaryByteBuffer, this._charBuffer, true);
        this._primaryByteBuffer.flip();
        this._charBuffer.flip();
    }

    private void addSecondaryByteBufferToPrimary() {
        int capacity = this._primaryByteBuffer.limit() + this._secondaryByteBuffer.limit();
        if (this._primaryByteBuffer.capacity() > capacity) {
            capacity = this._primaryByteBuffer.capacity();
        }
        ByteBuffer tempBuffer = ByteBuffer.allocate(capacity);
        tempBuffer.put(this._secondaryByteBuffer);
        tempBuffer.put(this._primaryByteBuffer);
        this._primaryByteBuffer.flip();
        this._secondaryByteBuffer.flip();
    }

    private LineCountResult countNumberOfLines(CharBuffer charBuffer2) {
        int linesNumber = 0;
        ArrayList<Integer> linesInfo = new ArrayList<Integer>();
        int i = 0;
        while (i < charBuffer2.limit()) {
            char ch = charBuffer2.get(i);
            switch (ch) {
                case '\r': {
                    char nextChar;
                    if (i < charBuffer2.limit() - 1 && (nextChar = charBuffer2.get(i + 1)) == '\n') {
                        ++i;
                    }
                    linesInfo.add(i);
                    ++linesNumber;
                    break;
                }
                case '\n': {
                    linesInfo.add(i);
                    ++linesNumber;
                    break;
                }
            }
            ++i;
        }
        LineCountResult result = new LineCountResult();
        result.lines = linesInfo.size();
        result.lineOffsets = new int[linesInfo.size()];
        int i2 = 0;
        while (i2 < linesInfo.size()) {
            result.lineOffsets[i2] = (Integer)linesInfo.get(i2);
            ++i2;
        }
        return result;
    }

    public void resetWatching() {
        this.setNotifyListeners(false);
        try {
            this.synchronizedStopWatching();
            this._lastFileLength = 0L;
            this._lastDocumentPosition = 0L;
            this._charBuffer.clear();
            this._primaryByteBuffer.clear();
            this._secondaryByteBuffer.clear();
        }
        finally {
            this.setNotifyListeners(true);
        }
    }

    private URL getLogURL() {
        try {
            return ((AbstractLogResource)this.getResource()).getURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private int estimateCharBufferSize(int backlogRows) {
        return backlogRows * this._meanCharactersPerLine;
    }

    private int estimateByteBufferSize(int backlogRows, Charset encoding) {
        float averageCharsPerByte = encoding.newDecoder().averageCharsPerByte();
        if (averageCharsPerByte == 0.0f) {
            return 0;
        }
        return (int)((float)backlogRows * (float)this._meanCharactersPerLine * (1.0f / averageCharsPerByte));
    }

    private boolean increaseCharBuffer() {
        int currentSize = this._charBuffer.capacity();
        currentSize = currentSize < 65536 ? (currentSize *= 2) : (currentSize += 65536);
        if (currentSize >= 0x100000) {
            return false;
        }
        try {
            CharBuffer newBuffer;
            this._charBuffer = newBuffer = CharBuffer.allocate(currentSize);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    private boolean increaseByteBuffer() {
        int currentSize = this._primaryByteBuffer.capacity();
        currentSize = currentSize < 65536 ? (currentSize *= 2) : (currentSize += 65536);
        if (currentSize >= 0x100000) {
            return false;
        }
        try {
            ByteBuffer newBuffer;
            this._primaryByteBuffer = newBuffer = ByteBuffer.allocate(currentSize);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    private boolean increaseSecondaryByteBuffer() {
        int currentSize = this._secondaryByteBuffer.capacity();
        currentSize = currentSize < 65536 ? (currentSize *= 2) : (currentSize += 65536);
        if (currentSize >= 0x100000) {
            return false;
        }
        try {
            ByteBuffer newBuffer;
            this._secondaryByteBuffer = newBuffer = ByteBuffer.allocate(currentSize);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    private int ensureByteBufferCapacity(int capacity) {
        while (this._primaryByteBuffer.capacity() < capacity) {
            boolean increased = this.increaseByteBuffer();
            if (increased) continue;
            return this._primaryByteBuffer.capacity();
        }
        return this._primaryByteBuffer.capacity();
    }

    private int ensureCharBufferCapacity(int capacity) {
        while (this._charBuffer.capacity() < capacity) {
            boolean increased = this.increaseCharBuffer();
            if (increased) continue;
            return this._charBuffer.capacity();
        }
        return this._charBuffer.capacity();
    }

    private int ensureSecondaryByteBufferCapacity(int capacity) {
        while (this._secondaryByteBuffer.capacity() < capacity) {
            boolean increased = this.increaseSecondaryByteBuffer();
            if (increased) continue;
            return this._secondaryByteBuffer.capacity();
        }
        return this._secondaryByteBuffer.capacity();
    }

    private static class LineCountResult {
        public int lines;
        int[] lineOffsets;

        private LineCountResult() {
        }
    }

    private static class ChunkReadResult {
        public LineCountResult lineCount;
        public boolean bufferLimitReached = false;
        public boolean inputLimitReached = false;
        public boolean ioError = false;
        public int bytesRead = 0;

        private ChunkReadResult() {
        }
    }
}

