/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.logging.impl.LineBasedLogWatcher;
import com.aptana.ide.logging.impl.LogWatcherConfiguration;
import com.aptana.ide.logging.impl.WebLogResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;

public class WebLineBasedLogWatcher
extends LineBasedLogWatcher {
    public WebLineBasedLogWatcher(WebLogResource resource, LogWatcherConfiguration config) {
        super(config, resource);
    }

    protected long getCurrentLogLength() throws IOException {
        int result;
        HttpURLConnection connection = (HttpURLConnection)this.getUrl().openConnection();
        connection.setRequestMethod("HEAD");
        try {
            connection.connect();
        }
        finally {
            connection.disconnect();
        }
        try {
            result = connection.getContentLength();
        }
        finally {
            connection.disconnect();
        }
        return result;
    }

    protected void readData(int startPos, ByteBuffer buffer, int maxBytesToRead) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.getUrl().openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Range", "bytes=" + startPos + "-" + (startPos + maxBytesToRead));
        connection.setDoInput(true);
        HttpURLConnection.setFollowRedirects(true);
        try {
            connection.connect();
        }
        finally {
            connection.disconnect();
        }
        try {
            int got;
            InputStream stream = (InputStream)connection.getContent();
            int gotBytes = 0;
            byte[] to = buffer.array();
            while ((got = stream.read(to, gotBytes, maxBytesToRead - gotBytes)) != -1 && (gotBytes += got) != maxBytesToRead) {
            }
            buffer.limit(gotBytes);
        }
        finally {
            connection.disconnect();
        }
    }

    protected URL getUrl() {
        try {
            return this.getResource().getURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

