/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.portal.server;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.jetty.ResourceBaseServlet;
import com.aptana.ide.server.jetty.comet.ClientLoader;
import com.aptana.ide.server.jetty.comet.ICometClient;
import com.aptana.ide.server.jetty.portal.ClientLister;
import com.aptana.ide.server.jetty.portal.PortalProxyServlet;
import com.aptana.ide.server.jetty.portal.PortalService;
import com.aptana.ide.server.jetty.portal.PortalServiceLoader;
import com.aptana.ide.server.portal.PortalPlugin;
import dojox.cometd.Bayeux;
import java.io.IOException;
import java.net.URL;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.ContinuationBayeux;
import org.mortbay.cometd.continuation.ContinuationCometdServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class MyAptanaServer {
    private static final int HTTP_START_PORT = 8500;
    private static final int HTTP_END_PORT = 8599;
    private static final int COMET_START_PORT = 8600;
    private static final int COMET_END_PORT = 8699;
    private static final String LOCAL_HOST = "127.0.0.1";
    private static MyAptanaServer server;
    private Server jettyServer;
    private URL startURL;
    private AbstractBayeux bayeux;
    private ClientLoader loader;
    private ClientLister lister;
    private int lastHTTPPort = 8499;
    private int lastCometPort = 8599;

    private MyAptanaServer() {
    }

    private void start() {
        if (this.lastHTTPPort == 8598) {
            this.lastHTTPPort = 8499;
        }
        this.lastHTTPPort = ServerManager.findFreePort((int)(this.lastHTTPPort + 1), (int)8599);
        if (this.lastCometPort == 8698) {
            this.lastCometPort = 8599;
        }
        this.lastCometPort = ServerManager.findFreePort((int)(this.lastCometPort + 1), (int)8699);
        this.jettyServer = new Server(this.lastHTTPPort);
        this.jettyServer.getConnectors()[0].setHost(LOCAL_HOST);
        SocketConnector connector = new SocketConnector();
        connector.setPort(this.lastCometPort);
        connector.setHost(LOCAL_HOST);
        this.jettyServer.addConnector((Connector)connector);
        Context httpContext = new Context((HandlerContainer)this.jettyServer, "/", 1);
        try {
            StringBuilder url = new StringBuilder("http://127.0.0.1:");
            url.append(this.lastHTTPPort).append("/index.html");
            url.append("?port=").append(this.lastCometPort);
            url.append("&pv=").append(PortalServiceLoader.getLoader().getLatestPortalVersion());
            this.startURL = new URL(url.toString());
            PortalServiceLoader.getLoader().switchPortalLocations();
            PortalService[] portalServiceArray = PortalServiceLoader.getLoader().getPortlets();
            int n = 0;
            int n2 = portalServiceArray.length;
            while (n < n2) {
                PortalService p = portalServiceArray[n];
                String id = p.getId();
                if (id.equals("aptana")) {
                    ResourceBaseServlet servlet = new ResourceBaseServlet(p.getFolder());
                    servlet.setNoCache(true);
                    httpContext.addServlet(new ServletHolder((Servlet)servlet), "/");
                }
                ++n;
            }
            httpContext.addServlet(new ServletHolder((Servlet)new PortalProxyServlet()), "/proxy");
            ContinuationCometdServlet cometServlet = new ContinuationCometdServlet();
            ServletHolder cometHolder = new ServletHolder((Servlet)cometServlet);
            cometHolder.setInitParameter("timeout", "30000");
            cometHolder.setInitParameter("multi-timeout", "1500");
            cometHolder.setInitParameter("verbose", "true");
            cometHolder.setInitParameter("rpcSupport", "true");
            if (AptanaCorePlugin.getDefault().getPluginPreferences().getBoolean("com.aptana.ide.core.PREF_ENABLE_DEBUGGING")) {
                cometHolder.setInitParameter("logLevel", "1");
            } else {
                cometHolder.setInitParameter("logLevel", "0");
            }
            httpContext.addServlet(cometHolder, "/cometd");
            this.jettyServer.setStopAtShutdown(true);
            this.jettyServer.start();
            this.bayeux = cometServlet.getBayeux();
            if (this.loader != null) {
                this.loader.destroy();
            }
            this.loader = ClientLoader.loadClients((Bayeux)this.bayeux);
            this.lister = new ClientLister(this.loader);
            this.lister.init((Bayeux)this.bayeux);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)PortalPlugin.getDefault(), (String)"Error finding the root for My Aptana page", (Throwable)e);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PortalPlugin.getDefault(), (String)"Error starting the server for My Aptana page", (Throwable)e);
        }
    }

    public URL getStartURL() {
        return this.startURL;
    }

    public static MyAptanaServer getServer() {
        if (server == null) {
            server = new MyAptanaServer();
            server.start();
        }
        return server;
    }

    public void restart() {
        PortalServiceLoader.getLoader().copyPortalContents();
        Job job = new Job("Downloading portal contents"){

            protected IStatus run(IProgressMonitor monitor) {
                PortalServiceLoader.getLoader().downloadPortalContents();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        try {
            this.jettyServer.stop();
            this.jettyServer.setStopAtShutdown(false);
            if (this.loader != null) {
                ICometClient[] iCometClientArray = this.loader.getClients();
                int n = 0;
                int n2 = iCometClientArray.length;
                while (n < n2) {
                    ICometClient client = iCometClientArray[n];
                    client.destroy();
                    ++n;
                }
            }
            if (this.lister != null) {
                this.lister.destroy();
            }
            if (this.bayeux instanceof ContinuationBayeux) {
                ((ContinuationBayeux)this.bayeux).destroy();
            }
            this.jettyServer.destroy();
            this.start();
        }
        catch (IllegalStateException e) {
            IdeLog.logInfo((Plugin)PortalPlugin.getDefault(), (String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PortalPlugin.getDefault(), (String)"Error restarting My Aptana server", (Throwable)e);
        }
    }
}

