/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.rcp;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.rcp.IdePlugin;
import com.aptana.ide.rcp.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.cheatsheets.ICheatSheetViewer;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.osgi.framework.Bundle;

public class AptanaCheatSheetViewer
implements ICheatSheetViewer {
    Browser browser;
    URL contentURL;
    CheatSheetElement contentElement;
    CheatSheetParser parser;
    String cheatSheet;
    DocumentBuilder documentBuilder = CheatSheetPlugin.getPlugin().getDocumentBuilder();

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AptanaCheatSheetViewer.this.dispose();
            }
        });
    }

    public Control getControl() {
        return this.browser;
    }

    public String getCheatSheetID() {
        if (this.getContent() != null) {
            return this.getContent().getID();
        }
        return null;
    }

    private CheatSheetElement getContent() {
        return this.contentElement;
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public void setInput(String id) {
        if (id != null) {
            CheatSheetElement element = null;
            element = CheatSheetRegistryReader.getInstance().findCheatSheet(id);
            this.browser.setText(this.getContent(element));
        }
    }

    public void setInput(String id, String name, URL url) {
        if (url != null) {
            this.browser.setUrl(url.toString());
            this.browser.update();
        } else {
            this.setInput(id);
        }
    }

    private String getContent(CheatSheetElement element) {
        this.contentElement = element;
        this.contentURL = null;
        if (element != null) {
            Bundle bundle = null;
            if (element != null && element.getConfigurationElement() != null) {
                try {
                    String pluginId = element.getConfigurationElement().getNamespace();
                    bundle = Platform.getBundle((String)pluginId);
                }
                catch (Exception exception) {}
            }
            if (bundle != null) {
                this.contentURL = FileLocator.find((Bundle)bundle, (IPath)new Path(element.getContentFile()), null);
            }
            if (this.contentURL == null) {
                try {
                    URL checker = new URL(element.getContentFile());
                    if (checker.getProtocol().equalsIgnoreCase("http")) {
                        this.contentURL = checker;
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return this.readFile();
    }

    private void dispose() {
    }

    private String readFile() {
        InputStream is = null;
        try {
            is = this.contentURL.openStream();
        }
        catch (Exception exception) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)StringUtils.format((String)Messages.AptanaCheatSheetViewer_ErrorOpeningFile, (String)this.contentURL.getFile()));
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int c = -1;
        try {
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)StringUtils.format((String)Messages.AptanaCheatSheetViewer_UnableToReadFile, (String)this.contentURL.getFile()), (Throwable)e);
        }
        return sb.toString();
    }

    public void reset(Map cheatSheetData) {
    }
}

