/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.editor.css.CSSErrorManager;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.js.JSErrorManager;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.FileError;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.UnifiedErrorManager;
import com.aptana.ide.editors.unified.errors.UnifiedErrorReporter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.IOffsetMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITypedRegion;

public class HTMLErrorManager
extends UnifiedErrorManager {
    JSErrorManager jsErrorManager;
    CSSErrorManager cssErrorManager;

    public HTMLErrorManager(FileService fileService) {
        super(fileService, "text/html");
        this.jsErrorManager = new JSErrorManager(this.fileService);
        this.cssErrorManager = new CSSErrorManager(this.fileService);
    }

    public IFileError[] parseForErrors(String path, String source, IFileSourceProvider sourceProvider) {
        UnifiedErrorReporter reporter = new UnifiedErrorReporter(sourceProvider);
        String htmlSource = this.extractLanguage("text/html", source, this);
        IFileError[] errs = super.parseForErrors(path, htmlSource, sourceProvider);
        reporter.addErrors(errs);
        String jsSource = this.extractLanguage("text/javascript", source, (UnifiedErrorManager)this.jsErrorManager);
        IFileError[] err = this.jsErrorManager.parseForErrors(path, jsSource, sourceProvider);
        reporter.addErrors(err);
        String cssSource = this.extractLanguage("text/css", source, (UnifiedErrorManager)this.cssErrorManager);
        err = this.cssErrorManager.parseForErrors(path, cssSource, sourceProvider);
        reporter.addErrors(err);
        err = reporter.getErrors();
        List validErrors = this.getValidErrors(err);
        err = validErrors.toArray(new IFileError[validErrors.size()]);
        Arrays.sort(err, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                FileError a = (FileError)arg0;
                FileError b = (FileError)arg1;
                return a.getLineNumber() - b.getLineNumber();
            }
        });
        Arrays.sort(err, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                FileError a = (FileError)arg0;
                FileError b = (FileError)arg1;
                return b.getSeverity() - a.getSeverity();
            }
        });
        return err;
    }

    private List getValidErrors(IFileError[] err) {
        ArrayList<IFileError> validErrors = new ArrayList<IFileError>();
        int i = 0;
        while (i < err.length) {
            IFileError fe = err[i];
            if (!"invalid return".equalsIgnoreCase(fe.getMessage())) {
                validErrors.add(fe);
            } else {
                try {
                    Lexeme prev;
                    IOffsetMapper mapper;
                    int index;
                    ITypedRegion region = this.fileService.getPartitionAtOffset(fe.getOffset());
                    IFileLanguageService service = this.fileService.getLanguageService("text/html");
                    if (!(service == null || service.getOffsetMapper() == null || (index = (mapper = service.getOffsetMapper()).getLexemeIndexFromDocumentOffset(region.getOffset())) - 1 <= 0 || index - 1 >= mapper.getLexemeList().size() || (prev = mapper.getLexemeAtIndex(index - 1)).getLanguage().equals("text/html") && prev.getToken().getTypeIndex() == 29)) {
                        validErrors.add(fe);
                    }
                }
                catch (Exception exception) {
                    validErrors.add(fe);
                }
            }
            ++i;
        }
        return validErrors;
    }

    private String extractLanguage(String lang, String source, UnifiedErrorManager manager) {
        if (source == null || source == "") {
            return "";
        }
        if (this.fileService != null) {
            ITypedRegion[] partitions = this.fileService.getPartitions();
            ArrayList<ITypedRegion> strip = new ArrayList<ITypedRegion>();
            if (partitions != null) {
                int i = 0;
                while (i < partitions.length) {
                    ITypedRegion partition = partitions[i];
                    int start = partition.getOffset();
                    int length = partition.getLength();
                    if (!partition.getType().equals(lang)) {
                        if (start >= 0 && length > 0) {
                            strip.add(partition);
                        }
                    } else {
                        source = manager.processLanguagePartition(partition, source);
                    }
                    ++i;
                }
                char[] sourceArray = source.toCharArray();
                for (ITypedRegion partition : strip) {
                    int start = partition.getOffset();
                    int length = partition.getLength();
                    this.stripCharsArray(sourceArray, start, length);
                }
                source = new String(sourceArray);
            }
        }
        return source;
    }

    protected void stripCharsArray(char[] source, int start, int length) {
        int end = start + length;
        char[] c = source;
        if (end > c.length) {
            end = c.length;
        }
        int i = start;
        while (i < end) {
            if (c[i] != '\r' && c[i] != '\n') {
                c[i] = 32;
            }
            ++i;
        }
    }

    public String filterMessage(String message) {
        message = message.replaceFirst("discarding", "should discard");
        message = message.replaceFirst("inserting", "should insert");
        message = message.replaceFirst("trimming", "should trim");
        return super.filterMessage(message);
    }

    protected IPreferenceStore getPreferenceStore() {
        if (PluginUtils.isPluginLoaded((Plugin)HTMLPlugin.getDefault())) {
            return HTMLPlugin.getDefault().getPreferenceStore();
        }
        return null;
    }
}

