/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.html.HTMLContributor;
import com.aptana.ide.editor.html.HTMLDocumentProvider;
import com.aptana.ide.editor.html.HTMLEditor;
import com.aptana.ide.editor.html.HTMLFileServiceFactory;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.Messages;
import com.aptana.ide.editor.html.actions.PrettyPrintHTML;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.untitled.BaseTextEditor;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class HTMLSourceEditor
extends UnifiedEditor {
    protected HTMLContributor contributor;
    private boolean _isDisposing = false;
    private boolean _isMarkingBothTags = false;
    private Action tidyAction;
    private ActivationListener fActivationListener;

    public HTMLSourceEditor() {
        this.addPluginToPreferenceStore(HTMLPlugin.getDefault());
        this._isMarkingBothTags = this.getPreferenceStore().getBoolean("com.aptana.ide.editor.html.EDITOR_HIGHLIGHT_START_END_TAGS");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
    }

    protected void createActions() {
        this.tidyAction = new Action(Messages.HTMLSourceEditor_RunHTMLTidy){

            public void run() {
                PrettyPrintHTML formatter = new PrettyPrintHTML();
                formatter.setActiveEditor(null, (IEditorPart)HTMLSourceEditor.this);
                formatter.run();
            }
        };
        super.createActions();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IAction)this.tidyAction);
    }

    protected IUnifiedEditorContributor createLocalContributor() {
        this.contributor = new HTMLContributor();
        return this.contributor;
    }

    public IFileServiceFactory getFileServiceFactory() {
        return HTMLFileServiceFactory.getInstance();
    }

    public File getTempFile() {
        IEditorInput in = this.getEditorInput();
        File outFile = null;
        if (in instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            IPath path = CoreUIUtils.getPathOfIFileLocation((IFile)file);
            if (path != null) {
                File f = path.makeAbsolute().toFile();
                String location = this.getTempFileLocation(f, file.getName());
                outFile = new File(location);
            }
        } else if (in instanceof NonExistingFileEditorInput) {
            NonExistingFileEditorInput nin = (NonExistingFileEditorInput)in;
            IPath path = nin.getPath((Object)nin);
            String spath = path.toOSString();
            File f = new File(spath);
            String location = this.getTempFileLocation(f, path.lastSegment());
            outFile = new File(location);
        } else if (in instanceof IPathEditorInput) {
            IPathEditorInput pin = (IPathEditorInput)in;
            File path = pin.getPath().toFile();
            String location = this.getTempFileLocation(path, pin.getName());
            outFile = new File(location);
        }
        if (outFile != null) {
            outFile.deleteOnExit();
        }
        return outFile;
    }

    public String getTempFileLocation(File file, String name) {
        return file.getParentFile() + File.separator + ".tmp_" + name + "." + (int)(Math.random() * 100000.0) + "~";
    }

    public boolean isFileEditorInput() {
        return this.getEditorInput() instanceof IFileEditorInput || this.getEditorInput() instanceof IPathEditorInput || this.getEditorInput() instanceof NonExistingFileEditorInput;
    }

    public String getDefaultFileExtension() {
        return "html";
    }

    public void dispose() {
        if (this._isDisposing) {
            return;
        }
        this._isDisposing = true;
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        if (this.contributor != null) {
            this.contributor.dispose();
            this.contributor = null;
        }
        super.dispose();
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"com.aptana.ide.editor.html.preferences.GeneralPreferencePage", "com.aptana.ide.editor.html.preferences.ColorPizationreferencePage", "com.aptana.ide.editor.html.preferences.FoldingPreferencePage", "com.aptana.ide.editor.html.preferences.FormattingPreferencePage", "com.aptana.ide.editor.html.preferences.PreviewPreferencePage", "com.aptana.ide.editor.html.preferences.ProblemsPreferencePage", "com.aptana.ide.editor.html.preferences.CodeAssistPreferencePage", "com.aptana.ide.editor.html.preferences.TypingPreferencePage", "com.aptana.ide.editor.html.preferences.TidyPreferencePage", "org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.Spelling", "org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage"};
    }

    protected boolean isNewInput(IEditorInput input) {
        HTMLDocumentProvider.HTMLFileInfo cuInfo = this.getHTMLFileInfo(input);
        if (cuInfo == null) {
            throw new RuntimeException(Messages.HTMLSourceEditor_cuInfo_Null_At_DoSetInput);
        }
        HTMLDocumentProvider dp = (HTMLDocumentProvider)this.getDocumentProvider();
        IDocument document = dp.getDocument(input);
        DocumentSourceProvider provider = new DocumentSourceProvider(document, input);
        if (provider == null) {
            throw new RuntimeException(Messages.HTMLSourceEditor_Provider_Null);
        }
        return cuInfo.sourceProvider == null || !cuInfo.sourceProvider.equals(provider);
    }

    private HTMLDocumentProvider.HTMLFileInfo getHTMLFileInfo(IEditorInput input) {
        HTMLDocumentProvider dp = (HTMLDocumentProvider)this.getDocumentProvider();
        if (dp == null) {
            throw new RuntimeException(Messages.HTMLSourceEditor_Document_Provider_Null);
        }
        return (HTMLDocumentProvider.HTMLFileInfo)dp.getFileInfoPublic(input);
    }

    protected void updateFileInfo(IEditorInput input, DocumentSourceProvider provider, IDocument document) {
        super.updateFileInfo(input, provider, document);
        if (this.isNewInput(input)) {
            this.getHTMLFileInfo((IEditorInput)input).sourceProvider = provider;
        }
    }

    public IDocumentProvider createDocumentProvider() {
        return HTMLDocumentProvider.getInstance();
    }

    public boolean canMarkOccurrences(Lexeme lexeme) {
        IToken token = lexeme.getToken();
        int typeIndex = token.getTypeIndex();
        if (typeIndex == 51) {
            return false;
        }
        if (typeIndex == 41 || typeIndex == 27) {
            return true;
        }
        return super.canMarkOccurrences(lexeme);
    }

    protected void markOccurences(LexemeList lexemeList, Lexeme selectedLexeme) {
        boolean deferToParent = true;
        if (this._isMarkingBothTags && (selectedLexeme.typeIndex == 41 || selectedLexeme.typeIndex == 27)) {
            String selectedText;
            deferToParent = false;
            String normalizedSelectedText = selectedText = selectedLexeme.getText();
            if (selectedLexeme.typeIndex == 27 && selectedLexeme.length >= 3) {
                normalizedSelectedText = String.valueOf(selectedText.substring(0, 1)) + selectedText.substring(2);
            }
            int i = 0;
            while (i < lexemeList.size()) {
                Lexeme lexeme = lexemeList.get(i);
                if (lexeme != null) {
                    if (lexeme.isHighlighted()) {
                        lexeme.setHighlighted(false);
                    }
                    if (lexeme.typeIndex == 41 || lexeme.typeIndex == 27) {
                        if (lexeme.typeIndex == selectedLexeme.typeIndex && lexeme.length == selectedLexeme.length) {
                            if (selectedText.equals(lexeme.getText())) {
                                lexeme.setHighlighted(true);
                            }
                        } else if (lexeme.length - selectedLexeme.length == 1) {
                            String normalizedText;
                            if (lexeme.typeIndex == 27 && lexeme.length >= 3 && (normalizedText = String.valueOf(lexeme.getText().substring(0, 1)) + lexeme.getText().substring(2)).equals(selectedText)) {
                                lexeme.setHighlighted(true);
                            }
                        } else if (selectedLexeme.length - lexeme.length == 1 && normalizedSelectedText.equals(lexeme.getText())) {
                            lexeme.setHighlighted(true);
                        }
                    }
                }
                ++i;
            }
        }
        if (deferToParent) {
            super.markOccurences(lexemeList, selectedLexeme);
        }
    }

    protected BaseTextEditor.FileDialogFilterInfo getFileDialogFilterInformation(String fileName) {
        String fileExtension = this.getFileExtension(fileName);
        if (Messages.HTMLSourceEditor_ExtensionHTM.equals(fileExtension) || Messages.HTMLSourceEditor_ExtensionHTML.equals(fileExtension)) {
            BaseTextEditor.FileDialogFilterInfo filterInfo = new BaseTextEditor.FileDialogFilterInfo((BaseTextEditor)this);
            filterInfo.setFilterExtensions(new String[]{"*" + Messages.HTMLSourceEditor_ExtensionHTM, "*" + Messages.HTMLSourceEditor_ExtensionHTML, "*" + Messages.HTMLSourceEditor_ExtensionAll});
            filterInfo.setFilterNames(new String[]{Messages.HTMLSourceEditor_DescriptionHTM, Messages.HTMLSourceEditor_DescriptionHTML, Messages.HTMLSourceEditor_DescriptionAll});
            return filterInfo;
        }
        return super.getFileDialogFilterInformation(fileName);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.aptana.ide.editor.html.EDITOR_HIGHLIGHT_START_END_TAGS".equals(property)) {
            this._isMarkingBothTags = this.getPreferenceStore().getBoolean("com.aptana.ide.editor.html.EDITOR_HIGHLIGHT_START_END_TAGS");
        } else {
            super.handlePreferenceStoreChanged(event);
        }
    }

    private class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part instanceof HTMLEditor ? ((HTMLEditor)part).getEditor() : part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        private void handleActivation() {
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart == HTMLSourceEditor.this) {
                this.fIsHandlingActivation = true;
                try {
                    HTMLSourceEditor.this.safelySanityCheckState(HTMLSourceEditor.this.getEditorInput());
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == HTMLSourceEditor.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ActivationListener.this.handleActivation();
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

