/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.contentassist;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.KeyValuePair;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.ImageUtils;
import com.aptana.ide.editor.html.HTMLLanguageEnvironment;
import com.aptana.ide.editor.html.HTMLOffsetMapper;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.contentassist.HTMLCompletionProposal;
import com.aptana.ide.editor.html.contentassist.HTMLCompletionProposalComparator;
import com.aptana.ide.editor.html.contentassist.HTMLContextInformationValidator;
import com.aptana.ide.editor.html.contentassist.HTMLContextLocation;
import com.aptana.ide.editor.html.contentassist.Messages;
import com.aptana.ide.editor.html.parsing.HTMLParseState;
import com.aptana.ide.editor.html.parsing.HTMLUtils;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.contentassist.CodeAssistExpression;
import com.aptana.ide.editors.unified.contentassist.UnifiedContentAssistProcessor;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.metadata.ElementMetadata;
import com.aptana.ide.metadata.EventMetadata;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataEnvironment;
import com.aptana.ide.metadata.MetadataEnvironment;
import com.aptana.ide.metadata.ValueMetadata;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.ParseNodeAttribute;
import com.aptana.ide.parsing.xpath.ParseNodeXPath;
import com.aptana.ide.server.jetty.server.HTMLContextRootUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.jaxen.JaxenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLContentAssistProcessor
extends UnifiedContentAssistProcessor
implements IContentAssistProcessor {
    private IContextInformationValidator validator;
    public static Hashtable usage = new Hashtable();
    private static Image fIconField = UnifiedEditorsPlugin.getImage((String)"icons/field_public.gif");
    private static Image fIconFieldGuess = UnifiedEditorsPlugin.getImage((String)"icons/field_public_guess.gif");
    private static Image fIconTag = UnifiedEditorsPlugin.getImage((String)"icons/html_tag.gif");
    private static Image fIconEvent = UnifiedEditorsPlugin.getImage((String)"icons/event.gif");
    private static Image fIconFile = UnifiedEditorsPlugin.getImage((String)"icons/file.gif");
    private static Image fIconFolder = UnifiedEditorsPlugin.getImage((String)"icons/folder.gif");
    private HTMLCompletionProposalComparator contentAssistComparator;
    private String AUTO_ADDED = "Auto-added from environment";
    public static String ERROR = "ERROR";
    public static String OUTSIDE_ELEMENT = "OUTSIDE_ELEMENT";
    public static String INSIDE_OPEN_ELEMENT = "INSIDE_OPEN_ELEMENT";
    public static String INSIDE_END_TAG = "INSIDE_END_TAG";
    private EditorFileContext context;
    private IMetadataEnvironment environment;
    private Hashtable additionalProposals = new Hashtable();

    public HTMLContentAssistProcessor(EditorFileContext context) {
        this.context = context;
        this.environment = (IMetadataEnvironment)HTMLLanguageEnvironment.getInstance().getRuntimeEnvironment();
        this.contentAssistComparator = new HTMLCompletionProposalComparator();
        this.validator = new HTMLContextInformationValidator(this);
    }

    public ICompletionProposal[] computeInnerCompletionProposals(ITextViewer viewer, int offset, int position, LexemeList lexemeList, char activationChar, char previousChar) {
        this.additionalProposals.clear();
        HTMLContextLocation currentLocation = this.getLocation(offset, lexemeList);
        String tagPrefix = currentLocation.getTagName();
        ICompletionProposal[] result = null;
        if (this.unifiedViewer != null && this.unifiedViewer.isHotkeyActivated()) {
            this.unifiedViewer.setHotkeyActivated(false);
            activationChar = DEFAULT_CHARACTER;
        }
        if (position < 0) {
            return null;
        }
        Lexeme currentLexeme = lexemeList.get(position);
        if (currentLocation.getLocation().equals(ERROR)) {
            return result;
        }
        if (currentLocation.getLocation().equals(INSIDE_END_TAG) && currentLocation.getAttributes().size() == 0) {
            return this.getTagCompletionProposals(tagPrefix, previousChar, offset, currentLexeme, lexemeList);
        }
        if (currentLocation.getLocation().equals(OUTSIDE_ELEMENT) && previousChar == '/') {
            return this.getTagCompletionProposals("", activationChar, offset, currentLexeme, lexemeList);
        }
        if (currentLocation.getLocation().equals(OUTSIDE_ELEMENT) && (activationChar == '<' || activationChar == DEFAULT_CHARACTER)) {
            return this.getTagCompletionProposals("", previousChar, offset, currentLexeme, lexemeList);
        }
        ArrayList<KeyValuePair> attributes = currentLocation.getAttributes();
        String attributePrefix = null;
        String valuePrefix = null;
        if (attributes.size() > 0) {
            for (KeyValuePair kvp : attributes) {
                if (kvp.getLocation() != currentLexeme.offset) continue;
                attributePrefix = (String)kvp.getKey();
                valuePrefix = (String)kvp.getValue();
                break;
            }
        }
        if (currentLocation.getLocation().equals(INSIDE_OPEN_ELEMENT)) {
            if ((previousChar == ' ' || previousChar == '\t') && tagPrefix != null) {
                if (HTMLUtils.insideQuotedString(currentLexeme, offset)) {
                    return null;
                }
                attributePrefix = "";
                if (currentLexeme.getCategoryIndex() != 0) {
                    valuePrefix = null;
                }
            }
            if (attributePrefix == null || currentLexeme.typeIndex == 41 && currentLexeme.containsOffset(offset)) {
                result = this.getTagCompletionProposals(tagPrefix, previousChar, offset, currentLexeme, lexemeList);
            } else if (valuePrefix != null) {
                if (valuePrefix.equals("/")) {
                    valuePrefix = "";
                }
                result = this.getAttributeValueCompletionProposals(tagPrefix, attributePrefix, valuePrefix, offset);
                String strippedValue = StringUtils.trimStringQuotes((String)valuePrefix);
                HTMLContentAssistProcessor.setSelection((String)strippedValue, (ICompletionProposal[])result);
            } else {
                Lexeme endTag;
                Lexeme startTag = HTMLUtils.getTagOpenLexeme(currentLexeme, lexemeList);
                Map<String, String> attribs = HTMLUtils.gatherAttributes(startTag, endTag = HTMLUtils.getTagCloseLexeme(currentLexeme, lexemeList), lexemeList);
                boolean attributeQuoted = attribs.get(attributePrefix) != null;
                result = this.getAttributeCompletionProposals(tagPrefix, attributePrefix, previousChar, attributes, attributeQuoted, offset);
                HTMLContentAssistProcessor.setSelection((String)attributePrefix.toLowerCase(), (ICompletionProposal[])result);
            }
        }
        return result;
    }

    public ICompletionProposal[] getAttributeValueCompletionProposals(String tagPrefix2, String attributePrefix2, String valuePrefix, int offset) {
        if (tagPrefix2 == null || attributePrefix2 == null) {
            return null;
        }
        String strippedValue = StringUtils.trimStringQuotes((String)valuePrefix);
        ArrayList<HTMLCompletionProposal> completionProposals = new ArrayList<HTMLCompletionProposal>();
        ArrayList<String> addedFields = new ArrayList<String>();
        Hashtable fields = this.environment.getGlobalFields();
        String tagNameLower = tagPrefix2.toLowerCase();
        String propertyNameLower = attributePrefix2.toLowerCase();
        String valueNameLower = strippedValue.toLowerCase();
        int beginOffset = HTMLContentAssistProcessor.getOffsetForInsertion(this.getHTMLOffsetMapper().getCurrentLexeme(), offset);
        int replaceLength = valueNameLower.length();
        Lexeme curLexeme = this.getHTMLOffsetMapper().getCurrentLexeme();
        if (curLexeme.getCategoryIndex() == 0) {
            beginOffset = curLexeme.offset;
        }
        if (valuePrefix.startsWith("\"") || valuePrefix.startsWith("'")) {
            ++beginOffset;
        }
        int sortingType = 1;
        ElementMetadata em = this.environment.getElement(tagNameLower);
        FieldMetadata fm = null;
        fm = em == null ? (FieldMetadata)fields.get(propertyNameLower) : (FieldMetadata)em.getFields().get(propertyNameLower);
        if (fm != null) {
            ICompletionProposal[] props = this.getFieldMetadataCompletionProposals(em, fm, beginOffset, replaceLength, sortingType);
            completionProposals.addAll((Collection)Arrays.asList(props));
        }
        try {
            if (propertyNameLower.equals("src")) {
                ICompletionProposal[] fileProps = this.getFilePathCompletionProposals(valuePrefix, beginOffset, replaceLength, sortingType);
                completionProposals.addAll((Collection)Arrays.asList(fileProps));
            }
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.HTMLContentAssistProcessor_ErrorComputingFilePath, (Throwable)ex);
        }
        ICompletionProposal[] xPathProps = this.getXPathCompletionProposals(propertyNameLower, beginOffset, replaceLength, sortingType);
        completionProposals.addAll((Collection)Arrays.asList(xPathProps));
        if (this.additionalProposals.containsKey(propertyNameLower)) {
            ArrayList addl = (ArrayList)this.additionalProposals.get(fm.getName());
            int i = 0;
            while (i < addl.size()) {
                String s = (String)addl.get(i);
                String trimmedValue = StringUtils.trimStringQuotes((String)StringUtils.trimStringQuotes((String)s));
                if (!trimmedValue.equals("")) {
                    String replaceString = trimmedValue;
                    String displayString = trimmedValue;
                    int cursorPosition = replaceString.length();
                    HTMLCompletionProposal cp = new HTMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconFieldGuess, displayString, null, "<b>" + trimmedValue + "</b><br>" + this.AUTO_ADDED, sortingType, this.unifiedViewer, null);
                    if (cp != null && !addedFields.contains(s)) {
                        addedFields.add(s);
                        completionProposals.add(cp);
                    }
                }
                ++i;
            }
        }
        ICompletionProposal[] result = completionProposals.toArray(new ICompletionProposal[completionProposals.size()]);
        Arrays.sort(result, this.contentAssistComparator);
        return result;
    }

    public HTMLContextLocation getLocation(int offset, LexemeList ll) {
        HTMLContextLocation cl = new HTMLContextLocation();
        cl.setLocation(OUTSIDE_ELEMENT);
        if (offset == 0) {
            return cl;
        }
        int currentLexemePosition = this.computeCurrentLexemeIndex(offset, ll);
        KeyValuePair currentAttribute = null;
        while (currentLexemePosition >= 0) {
            Lexeme curLexeme = ll.get(currentLexemePosition);
            if (curLexeme.typeIndex == 43) {
                KeyValuePair foundAttribute;
                boolean isAttributeValue = false;
                if (currentLexemePosition > 0) {
                    Lexeme prev = ll.get(currentLexemePosition - 1);
                    if (prev.typeIndex == 29) {
                        isAttributeValue = true;
                    }
                }
                String lexemeText = curLexeme.getText();
                if (isAttributeValue) {
                    currentAttribute = new KeyValuePair((Object)"PLACEHOLDER", (Object)lexemeText, curLexeme.offset);
                } else if (currentAttribute != null) {
                    foundAttribute = cl.find(lexemeText, currentAttribute.getLocation());
                    if (foundAttribute != null && foundAttribute.getLocation() != curLexeme.offset) {
                        cl.getAttributes().remove(foundAttribute);
                    }
                    cl.getAttributes().add(0, new KeyValuePair((Object)lexemeText, currentAttribute.getValue(), currentAttribute.getLocation()));
                    currentAttribute = null;
                } else {
                    foundAttribute = cl.find(lexemeText, curLexeme.offset);
                    if (foundAttribute != null && foundAttribute.getLocation() != curLexeme.offset) {
                        cl.getAttributes().remove(foundAttribute);
                    }
                    cl.getAttributes().add(0, new KeyValuePair((Object)lexemeText, null, curLexeme.offset));
                    currentAttribute = null;
                }
            }
            if (curLexeme.typeIndex == 29 && currentAttribute == null) {
                currentAttribute = new KeyValuePair((Object)"PLACEHOLDER", (Object)"", curLexeme.offset);
            }
            if (curLexeme.typeIndex == 44) {
                currentAttribute = new KeyValuePair((Object)"PLACEHOLDER", (Object)curLexeme.getText(), curLexeme.offset);
            }
            if (curLexeme.typeIndex == 41) {
                cl.setTagName(curLexeme.getText().replaceAll("<", ""));
            }
            if (curLexeme.typeIndex == 27) {
                cl.setTagName(curLexeme.getText().replaceAll("</", ""));
                cl.setLocation(INSIDE_END_TAG);
                break;
            }
            if (curLexeme.typeIndex == 30) {
                cl.setLocation(OUTSIDE_ELEMENT);
                break;
            }
            if (curLexeme.typeIndex == 0 && curLexeme.getText().equals("/")) {
                cl.setLocation(ERROR);
                break;
            }
            if (curLexeme.typeIndex == 39 && (curLexeme.containsOffset(offset) || offset >= curLexeme.getEndingOffset())) {
                cl.setLocation(OUTSIDE_ELEMENT);
                break;
            }
            if (curLexeme.typeIndex == 41 || curLexeme.typeIndex == 0 && curLexeme.getText().equals("<")) {
                cl.setLocation(INSIDE_OPEN_ELEMENT);
                break;
            }
            --currentLexemePosition;
        }
        return cl;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<', '/', ' ', '\t', '=', '>'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'='};
    }

    public int[] getCompletionProposalSeparatorLexemes() {
        return new int[]{30, 39, 29, 41, 27};
    }

    public int[] getCompletionProposalIdleActivationTokens() {
        return new int[]{41, 27, 43};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.validator;
    }

    public String getErrorMessage() {
        return null;
    }

    public static int getOffsetForInsertion(Lexeme curLexeme, int offset) {
        if (curLexeme == null) {
            return offset;
        }
        int beginOffset = offset;
        if (curLexeme.typeIndex == 51) {
            return beginOffset;
        }
        if (curLexeme.getCategoryIndex() == 3 || curLexeme.getCategoryIndex() == 5 || HTMLUtils.isStartTag(curLexeme) || HTMLUtils.isEndTag(curLexeme)) {
            beginOffset = curLexeme.getStartingOffset();
        }
        return beginOffset;
    }

    public ICompletionProposal[] getAttributeCompletionProposals(String tagPrefix, String attributePrefix, char activationChar, ArrayList<KeyValuePair> addedAttributes, boolean hasAttachedValue, int offset) {
        if (tagPrefix == null) {
            return null;
        }
        Hashtable<String, HTMLCompletionProposal> completionProposals = new Hashtable<String, HTMLCompletionProposal>();
        String tagPrefixLower = tagPrefix.toLowerCase();
        String attributePrefixLower = attributePrefix.toLowerCase();
        ElementMetadata em = this.environment.getElement(tagPrefixLower);
        if (em == null) {
            return null;
        }
        int beginOffset = offset;
        Lexeme curLexeme = this.getHTMLOffsetMapper().getCurrentLexeme();
        if (curLexeme.typeIndex == 43) {
            beginOffset = curLexeme.getStartingOffset();
        }
        for (FieldMetadata fm : em.getFields().values()) {
            HTMLCompletionProposal cp = this.createFieldProposal(attributePrefixLower, beginOffset, em, fm, hasAttachedValue);
            completionProposals.put(fm.getName(), cp);
        }
        for (EventMetadata evm : em.getEvents().values()) {
            HTMLCompletionProposal cp = this.createEventProposal(attributePrefixLower, beginOffset, em, evm, hasAttachedValue);
            completionProposals.put(evm.getName(), cp);
        }
        ICompletionProposal[] result = completionProposals.values().toArray(new ICompletionProposal[completionProposals.size()]);
        Arrays.sort(result, this.contentAssistComparator);
        return result;
    }

    public HTMLCompletionProposal createFieldProposal(String attributePrefix, int beginOffset, ElementMetadata em, FieldMetadata fm, boolean hasAttachedValue) {
        String docText = this.environment.getFieldDocumentation(fm);
        String replaceString = fm.getName();
        String quoteString = HTMLUtils.quoteAttributeValue(this.getPreferenceStore(), "");
        boolean insertEquals = HTMLUtils.insertEquals(this.getPreferenceStore());
        if (!hasAttachedValue && insertEquals) {
            replaceString = String.valueOf(replaceString) + "=" + quoteString;
        }
        String displayString = fm.getName();
        int cursorPosition = replaceString.length();
        if (!hasAttachedValue && insertEquals && quoteString.length() == 2) {
            --cursorPosition;
        }
        int replaceLength = attributePrefix.length();
        Image[] userAgents = null;
        userAgents = fm.getUserAgents().length == 0 ? HTMLContentAssistProcessor.getUserAgentImages((String[])HTMLContentAssistProcessor.getUserAgents(), (String[])em.getUserAgentPlatformNames()) : HTMLContentAssistProcessor.getUserAgentImages((String[])HTMLContentAssistProcessor.getUserAgents(), (String[])fm.getUserAgentPlatformNames());
        HTMLCompletionProposal cp = new HTMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconField, displayString, null, docText, 1, this.unifiedViewer, userAgents);
        return cp;
    }

    public HTMLCompletionProposal createEventProposal(String attributePrefix, int beginOffset, ElementMetadata em, EventMetadata fm, boolean hasAttachedValue) {
        String docText = this.environment.getEventDocumentation(fm);
        String replaceString = fm.getName();
        String quoteString = HTMLUtils.quoteAttributeValue(this.getPreferenceStore(), "");
        boolean insertEquals = HTMLUtils.insertEquals(this.getPreferenceStore());
        if (!hasAttachedValue && insertEquals) {
            replaceString = String.valueOf(replaceString) + "=" + quoteString;
        }
        String displayString = fm.getName();
        int cursorPosition = replaceString.length();
        int replaceLength = attributePrefix.length();
        if (!hasAttachedValue && insertEquals && quoteString.length() == 2) {
            --cursorPosition;
        }
        Image[] userAgents = null;
        userAgents = fm.getUserAgents().length == 0 ? HTMLContentAssistProcessor.getUserAgentImages((String[])HTMLContentAssistProcessor.getUserAgents(), (String[])em.getUserAgentPlatformNames()) : HTMLContentAssistProcessor.getUserAgentImages((String[])HTMLContentAssistProcessor.getUserAgents(), (String[])fm.getUserAgentPlatformNames());
        HTMLCompletionProposal cp = new HTMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconEvent, displayString, null, docText, 1, this.unifiedViewer, userAgents);
        return cp;
    }

    public ICompletionProposal[] getTagCompletionProposals(String prefix, char activationChar, int offset, Lexeme currentLexeme, LexemeList lexemeList) {
        int cursorPosition;
        int replaceLength;
        IParseState parseState = this.context.getParseState();
        HTMLParseState htmlParseState = (HTMLParseState)parseState.getParseState("text/html");
        Hashtable<String, HTMLCompletionProposal> completionProposals = new Hashtable<String, HTMLCompletionProposal>();
        if (currentLexeme == null) {
            return null;
        }
        if (currentLexeme.typeIndex != 51 && !HTMLUtils.isStartTag(currentLexeme) && !HTMLUtils.isEndTag(currentLexeme)) {
            return null;
        }
        int tagClosedType = HTMLUtils.isTagClosed(currentLexeme, lexemeList);
        boolean tagClosed = tagClosedType != 1;
        String textPrefix = HTMLUtils.getOpenTagName(currentLexeme, offset);
        if (tagClosed) {
            textPrefix = HTMLUtils.getOpenTagName(currentLexeme, currentLexeme.getEndingOffset());
        }
        if (currentLexeme.typeIndex == 51) {
            textPrefix = "";
        }
        String testPrefix = textPrefix.toLowerCase();
        int beginOffset = HTMLContentAssistProcessor.getOffsetForInsertion(currentLexeme, offset);
        String[] em = this.environment.getAllElements();
        int i = 0;
        while (i < em.length) {
            String e = em[i];
            String docText = this.environment.getElementDocumentation(e);
            String displayString = e;
            String replaceString = e;
            replaceLength = textPrefix.length();
            cursorPosition = replaceString.length();
            if (HTMLUtils.isEndTag(currentLexeme)) {
                replaceString = tagClosed ? HTMLUtils.createOpenTag(replaceString, false) : HTMLUtils.createOpenTag(replaceString, true);
                replaceLength = currentLexeme.length;
                cursorPosition = replaceString.length();
            } else {
                boolean insertClosingTags = true;
                if (this.getPreferenceStore() != null) {
                    insertClosingTags = this.getPreferenceStore().getBoolean("com.aptana.ide.editor.html.AUTO_INSERT_CLOSE_TAGS");
                }
                if (insertClosingTags) {
                    int cursorOffset = 1;
                    boolean emptyTag = htmlParseState.isEmptyTagType(replaceString);
                    boolean isDocType = replaceString != null && replaceString.toLowerCase().startsWith("!doctype");
                    String startString = null;
                    if (emptyTag && !tagClosed && htmlParseState.getDocumentType() >= 6) {
                        startString = HTMLUtils.createSelfClosedTag(replaceString);
                        cursorOffset = 2;
                    } else {
                        startString = HTMLUtils.createOpenTag(replaceString, !tagClosed);
                    }
                    cursorPosition = startString.length();
                    if (!(tagClosed || HTMLUtils.isStartTagBalanced(currentLexeme, lexemeList, htmlParseState) || emptyTag || isDocType)) {
                        replaceString = String.valueOf(startString) + HTMLUtils.createCloseTag(replaceString, true);
                        cursorOffset = 1;
                    } else {
                        replaceString = startString;
                    }
                    if (!tagClosed) {
                        cursorPosition -= cursorOffset;
                    }
                } else {
                    replaceString = HTMLUtils.createOpenTag(replaceString, true);
                    cursorPosition = replaceString.length();
                }
                if (currentLexeme.typeIndex != 51) {
                    ++replaceLength;
                }
            }
            HTMLCompletionProposal cp = new HTMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconTag, displayString, null, docText, 1, this.unifiedViewer, HTMLContentAssistProcessor.getUserAgentImages((String[])HTMLContentAssistProcessor.getUserAgents(), (String[])this.environment.getUserAgentPlatformNames(e)));
            completionProposals.put(displayString, cp);
            ++i;
        }
        boolean addedCloseTag = false;
        Lexeme unclosed = HTMLUtils.getPreviousUnclosedTag(currentLexeme, lexemeList, htmlParseState);
        if (unclosed != null && !HTMLUtils.isStartTagBalanced(unclosed, lexemeList, htmlParseState)) {
            String displayString;
            String replaceString = displayString = HTMLUtils.stripTagEndings(unclosed.getText());
            boolean emptyTag = htmlParseState.isEmptyTagType(displayString);
            if (!emptyTag) {
                addedCloseTag = true;
                replaceString = tagClosed ? HTMLUtils.createCloseTag(replaceString, false) : HTMLUtils.createCloseTag(replaceString, true);
                replaceLength = this.getReplaceLengthByLexeme(currentLexeme, activationChar);
                cursorPosition = replaceString.length();
                displayString = "/" + displayString;
                ElementMetadata e = this.environment.getElement(unclosed);
                String docText = null;
                if (e != null) {
                    docText = this.environment.getElementDocumentation(e.getName());
                }
                HTMLCompletionProposal cp = new HTMLCompletionProposal(replaceString, currentLexeme.getStartingOffset(), replaceLength, cursorPosition, fIconTag, displayString, null, docText, 1, this.unifiedViewer, HTMLContentAssistProcessor.getAllUserAgentImages((String[])HTMLContentAssistProcessor.getUserAgents()));
                completionProposals.put(displayString, cp);
            }
        }
        ICompletionProposal[] result = completionProposals.values().toArray(new ICompletionProposal[completionProposals.size()]);
        Arrays.sort(result, this.contentAssistComparator);
        if (HTMLUtils.isEndTag(currentLexeme) && addedCloseTag) {
            HTMLContentAssistProcessor.setSelection((String)("/" + testPrefix), (ICompletionProposal[])result);
        } else {
            HTMLContentAssistProcessor.setSelection((String)testPrefix, (ICompletionProposal[])result);
        }
        return result;
    }

    public IOffsetMapper getOffsetMapper() {
        IFileLanguageService ls = this.context.getLanguageService("text/html");
        if (ls != null) {
            return ls.getOffsetMapper();
        }
        return null;
    }

    public HTMLOffsetMapper getHTMLOffsetMapper() {
        return (HTMLOffsetMapper)this.getOffsetMapper();
    }

    protected IPreferenceStore getPreferenceStore() {
        if (PluginUtils.isPluginLoaded((Plugin)HTMLPlugin.getDefault())) {
            return HTMLPlugin.getDefault().getPreferenceStore();
        }
        return null;
    }

    public IContextInformation[] computeInnerContextInformation(String documentSource, int offset, int position, LexemeList lexemeList) {
        IContextInformation[] ici = null;
        HTMLContextLocation currentLocation = this.getLocation(offset, lexemeList);
        String tagPrefix = currentLocation.getTagName();
        if (tagPrefix == null) {
            return null;
        }
        Hashtable fields = this.environment.getGlobalFields();
        ArrayList<KeyValuePair> attributes = currentLocation.getAttributes();
        if (attributes.size() == 0) {
            return null;
        }
        KeyValuePair attribute = attributes.get(attributes.size() - 1);
        String propertyNameLower = ((String)attribute.getKey()).toLowerCase();
        FieldMetadata fm = (FieldMetadata)fields.get(propertyNameLower);
        if (fm == null || fm.getValues().size() > 0) {
            return null;
        }
        ContextInformation ci = new ContextInformation("contextDisplayString", fm.getDescription());
        if (ci != null) {
            ici = new IContextInformation[]{ci};
        }
        return ici;
    }

    public Comparator<ICompletionProposal> getProposalComparator() {
        return this.contentAssistComparator;
    }

    private ICompletionProposal[] getFilePathCompletionProposals(String valuePrefix, int beginOffset, int replaceLength, int sortingType) {
        File[] files;
        String s;
        ArrayList<HTMLCompletionProposal> completionProposals = new ArrayList<HTMLCompletionProposal>();
        Map ht = ImageUtils.fileIconsHash;
        IEditorInput pathEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        String urlPrefix = null;
        if (pathEditor instanceof FileEditorInput) {
            urlPrefix = this.getProjectContextRoot(pathEditor);
        }
        String editorPath = CoreUIUtils.getPathFromEditorInput((IEditorInput)pathEditor);
        if (urlPrefix != null && !"".equals(urlPrefix) && valuePrefix != null && valuePrefix.indexOf(47) == 1) {
            editorPath = urlPrefix;
        }
        String currentPath = editorPath;
        if (valuePrefix != null && !"".equals(s = StringUtils.trimStringQuotes((String)valuePrefix))) {
            File current = new File(currentPath);
            currentPath = current.isDirectory() ? String.valueOf(currentPath) + s : String.valueOf(current.getParent().toString()) + File.separator + s;
        }
        if ((files = FileUtils.getFilesInDirectory((File)new File(currentPath))) == null) {
            return new ICompletionProposal[0];
        }
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (!f.getName().startsWith(".")) {
                String fileType = "";
                try {
                    fileType = FileSystemView.getFileSystemView().getSystemTypeDescription(f);
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)Messages.HTMLContentAssistProcessor_TypeDescriptionError, (Throwable)ex);
                }
                if (!f.toString().equals(editorPath)) {
                    Image image = null;
                    if (fileType != null) {
                        image = (Image)ht.get(fileType);
                    }
                    if (image == null) {
                        image = fIconFile;
                        if (f.isDirectory()) {
                            image = fIconFolder;
                        }
                    }
                    String replaceString = FileUtils.makeFilePathRelative((File)new File(editorPath), (File)f);
                    replaceString = replaceString.replaceAll("\\\\", "/");
                    String displayString = CoreUIUtils.getPathFromURI((String)replaceString);
                    int cursorPosition = replaceString.length();
                    HTMLCompletionProposal cp = new HTMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, image, displayString, null, f.toString(), sortingType, this.unifiedViewer, new Image[0]);
                    if (cp != null) {
                        completionProposals.add(cp);
                    }
                }
            }
            ++i;
        }
        return completionProposals.toArray(new ICompletionProposal[0]);
    }

    private String getProjectContextRoot(IEditorInput input) {
        String urlPrefix = null;
        FileEditorInput fei = (FileEditorInput)input;
        IFile file = fei.getFile();
        IProject project = file.getProject();
        urlPrefix = HTMLContextRootUtils.resolveURL((IProject)project, (String)"/");
        urlPrefix = project.getLocation().append(urlPrefix).toOSString();
        return urlPrefix;
    }

    public ICompletionProposal[] getXPathCompletionProposals(String attributeName, int offset, int replaceLength, int sortingType) {
        ArrayList<HTMLCompletionProposal> completionProposals = new ArrayList<HTMLCompletionProposal>();
        IParseNode root = this.context.getParseState().getRoot().getParseResults();
        String editors = null;
        if (this.getPreferenceStore() != null) {
            editors = this.getPreferenceStore().getString("com.aptana.ide.editors.CODE_ASSIST_EXPRESSIONS");
        }
        CodeAssistExpression[] expressions = CodeAssistExpression.deserializeErrorDescriptors(editors);
        int i = 0;
        while (i < expressions.length) {
            CodeAssistExpression expression = expressions[i];
            if (attributeName.matches(expression.getExpression())) {
                try {
                    ParseNodeXPath xpath = new ParseNodeXPath(expression.getXPath());
                    Object result = xpath.evaluate((Object)root);
                    if (result instanceof List) {
                        List xpathResult = (List)result;
                        for (Object element : xpathResult) {
                            int cursorPosition;
                            ParseNodeAttribute pna;
                            String replaceString;
                            HTMLCompletionProposal cp;
                            if (!(element instanceof ParseNodeAttribute) || (cp = new HTMLCompletionProposal(replaceString = (pna = (ParseNodeAttribute)element).getValue(), offset, replaceLength, cursorPosition = replaceString.length(), fIconFieldGuess, replaceString, null, "<b>" + replaceString + "</b><br>" + this.AUTO_ADDED, sortingType, this.unifiedViewer, null)) == null) continue;
                            completionProposals.add(cp);
                        }
                    }
                }
                catch (JaxenException e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (String)e.getMessage());
                }
            }
            ++i;
        }
        return completionProposals.toArray(new ICompletionProposal[0]);
    }

    private ICompletionProposal[] getFieldMetadataCompletionProposals(ElementMetadata em, FieldMetadata fm, int beginOffset, int replaceLength, int sortingType) {
        ArrayList<HTMLCompletionProposal> completionProposals = new ArrayList<HTMLCompletionProposal>();
        int i = 0;
        while (i < fm.getValues().size()) {
            ValueMetadata value = (ValueMetadata)fm.getValues().get(i);
            if (value.getName() != "*") {
                String docText = "";
                docText = MetadataEnvironment.getValueDocumentation((ValueMetadata)value);
                String replaceString = value.getName();
                String displayString = value.getName();
                if (replaceString.equals("*")) {
                    replaceString = "";
                }
                int cursorPosition = replaceString.length();
                Image[] userAgents = null;
                userAgents = value.getUserAgents().length == 0 && fm.getUserAgents().length == 0 ? HTMLContentAssistProcessor.getUserAgentImages((String[])HTMLContentAssistProcessor.getUserAgents(), (String[])em.getUserAgentPlatformNames()) : (value.getUserAgents().length == 0 ? HTMLContentAssistProcessor.getUserAgentImages((String[])HTMLContentAssistProcessor.getUserAgents(), (String[])fm.getUserAgentPlatformNames()) : HTMLContentAssistProcessor.getUserAgentImages((String[])HTMLContentAssistProcessor.getUserAgents(), (String[])value.getUserAgentPlatformNames()));
                HTMLCompletionProposal cp = new HTMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconField, displayString, null, docText, sortingType, this.unifiedViewer, userAgents);
                if (cp != null) {
                    completionProposals.add(cp);
                }
            }
            ++i;
        }
        return completionProposals.toArray(new ICompletionProposal[0]);
    }

    private int getReplaceLengthByLexeme(Lexeme lexeme, char activationChar) {
        int result;
        if (activationChar == '\u0000' && lexeme.typeIndex == 27) {
            result = 2;
        } else {
            String text = lexeme.getText();
            String trimmed = text.trim();
            result = trimmed.length();
        }
        return result;
    }
}

