/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.formatting;

import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.ui.editors.preferences.formatter.DefaultCodeFormatterConstants;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLCodeFormatterOptions {
    public String formatterTabChar;
    public int tabSize;
    public final HashSet<String> notWrappingTags = new HashSet();
    public final HashSet<String> allwaysWrap = new HashSet();
    public final HashSet<String> doNotIndent = new HashSet();
    public boolean doFormatting = true;
    public boolean doNotWrapSimple = true;

    public HTMLCodeFormatterOptions() {
        this.initFromPreferences();
    }

    public static Map createNotWrappingOptions() {
        Map map = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        map.put("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration", Boolean.TRUE);
        return map;
    }

    public static Map createNotIndentingOptions() {
        Map map = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        map.put("com.aptana.ide.editors.codeassist.formatter.insert_space_after_and_in_type_parameter", "html");
        return map;
    }

    private void initFromPreferences() {
        IPreferenceStore preferenceStore = HTMLPlugin.getDefault().getPreferenceStore();
        this.formatterTabChar = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
        this.tabSize = preferenceStore.getInt("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
        String sm = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_new_line_in_empty_type_declaration");
        this.initTags(sm, this.notWrappingTags);
        sm = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_new_line_in_empty_enum_declaration");
        this.initTags(sm, this.allwaysWrap);
        sm = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_space_after_and_in_type_parameter");
        this.initTags(sm, this.doNotIndent);
        String string = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant");
        if (string.length() > 0) {
            this.doFormatting = false;
        }
        this.doNotWrapSimple = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration");
    }

    private void initTags(String sm, HashSet<String> set) {
        if (sm == null) {
            return;
        }
        String[] nodes = sm.split(",");
        int i = 0;
        while (i < nodes.length) {
            String trim = nodes[i].trim();
            if (trim.length() > 0) {
                set.add(trim.toLowerCase());
            }
            ++i;
        }
    }

    public HTMLCodeFormatterOptions(Map map, IProject project) {
        if (project != null) {
            IEclipsePreferences preferences = new ProjectScope(project).getNode(HTMLPlugin.ID);
            String string = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size", null);
            if (string == null) {
                this.initFromPreferences();
                return;
            }
            this.formatterTabChar = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char", "");
            String sm = preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_in_empty_type_declaration", "a,span,i,b,em,strong,h1,h2,h3,h4,h5,h6,title,option");
            this.initTags(sm, this.notWrappingTags);
            sm = preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_in_empty_enum_declaration", "doctype,br,link,meta");
            this.initTags(sm, this.allwaysWrap);
            sm = preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_space_after_and_in_type_parameter", "");
            this.initTags(sm, this.doNotIndent);
            this.tabSize = Integer.parseInt(string);
            string = preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant", "");
            if (string.length() > 0) {
                this.doFormatting = false;
            }
            this.doNotWrapSimple = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration", true);
        } else if (map == null) {
            this.initFromPreferences();
        } else {
            Object object21a;
            Object object10;
            this.formatterTabChar = (String)map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
            String sm = (String)map.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_in_empty_type_declaration");
            this.initTags(sm, this.notWrappingTags);
            sm = (String)map.get("com.aptana.ide.editors.codeassist.formatter.insert_new_line_in_empty_enum_declaration");
            this.initTags(sm, this.allwaysWrap);
            sm = (String)map.get("com.aptana.ide.editors.codeassist.formatter.insert_space_after_and_in_type_parameter");
            this.initTags(sm, this.doNotIndent);
            if (this.formatterTabChar == null) {
                this.formatterTabChar = " ";
            }
            this.tabSize = (object10 = map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size")) != null ? Integer.parseInt(object10.toString()) : 4;
            String sma = (String)map.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant");
            if (sma != null && sma.length() > 0) {
                this.doFormatting = false;
            }
            if ((object21a = map.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration")) != null) {
                this.doNotWrapSimple = Boolean.parseBoolean(object21a.toString());
            }
        }
    }
}

