/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.parsing;

import com.aptana.ide.editor.html.parsing.Messages;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.parsing.IParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class HTMLLanguageRegistry {
    private static String TAG_PARSER = "parser";
    private static String TAG_ELEMENT_LANGUAGE = "element-language";
    private static String TAG_PI_LANGUAGE = "pi-language";
    private static String TAG_ATTRIBUTE_LANGUAGE = "attribute-language";
    private static String TAG_VALUE = "value";
    private static String ATTR_LANGUAGE = "language";
    private static String ATTR_ELEMENT_NAME = "element-name";
    private static String ATTR_ATTRIBUTE_NAME = "attribute-name";
    private static String ATTR_LANGUAGE_OWNS_ELEMENT = "language-owns-element";
    private static String ATTR_PI_NAME = "pi-name";
    private static String ATTR_HANDLES_EOF = "handles-eof";
    private static String ATTR_VALUE = "value";
    private Map<String, IParser> _parsers = new HashMap<String, IParser>();
    private Map<String, Boolean> _handlesEOF = new HashMap<String, Boolean>();
    private Map<String, Boolean> _languageOwnsElement = new HashMap<String, Boolean>();

    public IParser[] loadFromExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        ArrayList<IParser> parsers = new ArrayList<IParser>();
        int i = 0;
        while (i < elements.length) {
            String language;
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_PARSER) && (language = element.getAttribute(ATTR_LANGUAGE)) != null && language.length() > 0) {
                IParser parser = LanguageRegistry.createParser((String)language);
                this.registerElementLanguages(element.getChildren(TAG_ELEMENT_LANGUAGE), parser);
                this.registerPILanguages(element.getChildren(TAG_PI_LANGUAGE), parser);
                this.registerAttributeLanguages(element.getChildren(TAG_ATTRIBUTE_LANGUAGE), parser);
                parsers.add(parser);
            }
            ++i;
        }
        return parsers.toArray(new IParser[parsers.size()]);
    }

    private void registerAttributeLanguages(IConfigurationElement[] elements, IParser parser) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            IConfigurationElement[] attributeNames = element.getChildren(TAG_VALUE);
            int j = 0;
            while (j < attributeNames.length) {
                String attributeName = attributeNames[j].getAttribute(ATTR_VALUE);
                if (attributeName != null) {
                    this.setRegistryEntry(attributeName, "", "", parser);
                }
                ++j;
            }
            ++i;
        }
    }

    private void registerElementLanguages(IConfigurationElement[] elements, IParser parser) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String elementName = element.getAttribute(ATTR_ELEMENT_NAME);
            String attributeName = element.getAttribute(ATTR_ATTRIBUTE_NAME);
            if (attributeName != null) {
                IConfigurationElement[] attributeValues = element.getChildren(TAG_VALUE);
                int j = 0;
                while (j < attributeValues.length) {
                    String attributeValue = attributeValues[j].getAttribute(ATTR_VALUE);
                    if (attributeValue == null) {
                        attributeValue = "";
                    }
                    this.setRegistryEntry(elementName, attributeName, attributeValue, parser);
                    ++j;
                }
            } else {
                this.setRegistryEntry(elementName, "", "", parser);
                boolean languageOwnsElement = false;
                String ownsElement = element.getAttribute(ATTR_LANGUAGE_OWNS_ELEMENT);
                if (ownsElement != null) {
                    languageOwnsElement = Boolean.parseBoolean(ownsElement);
                }
                this.setLanguageOwnsElement(elementName, "", "", languageOwnsElement);
            }
            ++i;
        }
    }

    private void registerPILanguages(IConfigurationElement[] elements, IParser parser) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String piName = "<?" + element.getAttribute(ATTR_PI_NAME);
            this.setRegistryEntry(piName, "", "", parser);
            boolean eof = false;
            String handlesEOF = element.getAttribute(ATTR_HANDLES_EOF);
            if (handlesEOF != null) {
                eof = Boolean.getBoolean(handlesEOF);
            }
            this.setHandlesEOF(piName, "", "", eof);
            ++i;
        }
    }

    public void setHandlesEOF(String piName, String attributeName, String attributeValue, boolean eof) {
        String key = this.buildKey(piName, "", "");
        this._handlesEOF.put(key, eof);
    }

    public void setLanguageOwnsElement(String elementName, String attributeName, String attributeValue, boolean eof) {
        String key = this.buildKey(elementName, "", "");
        this._languageOwnsElement.put(key, eof);
    }

    public void setRegistryEntry(String elementName, String attributeName, String attributeValue, IParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException(Messages.LanguageRegistry_ParserMustBeDefined);
        }
        String key = this.buildKey(elementName, attributeName, attributeValue);
        this._parsers.put(key, parser);
    }

    public IParser getAttributeLanguage(String attributeName) {
        IParser result = null;
        String key = this.buildKey(attributeName, "", "");
        if (this._parsers.containsKey(key)) {
            result = this._parsers.get(key);
        }
        return result;
    }

    public IParser getElementLanguage(String elementName, String attributeName, String attributeValue) {
        IParser result = null;
        String key = this.buildKey(elementName, attributeName, attributeValue);
        if (this._parsers.containsKey(key)) {
            result = this._parsers.get(key);
        }
        return result;
    }

    public boolean getHandlesEOF(String processInstructionName) {
        String key = this.buildKey(processInstructionName, "", "");
        boolean result = false;
        if (this._handlesEOF.containsKey(key)) {
            result = this._handlesEOF.get(key);
        }
        return result;
    }

    public boolean getLanguageOwnsElement(String elementName) {
        String key = this.buildKey(elementName, "", "");
        boolean result = false;
        if (this._languageOwnsElement.containsKey(key)) {
            result = this._languageOwnsElement.get(key);
        }
        return result;
    }

    public IParser getPercentInstructionLanguage(String percentInstructionName) {
        IParser result = null;
        String key = this.buildKey(percentInstructionName, "", "");
        if (this._parsers.containsKey(key)) {
            result = this._parsers.get(key);
        }
        return result;
    }

    public IParser getProcessingInstructionLanguage(String processInstructionName) {
        IParser result = null;
        String key = this.buildKey(processInstructionName, "", "");
        if (this._parsers.containsKey(key)) {
            result = this._parsers.get(key);
        }
        return result;
    }

    private String buildKey(String elementName, String attributeName, String attributeValue) {
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException(Messages.LanguageRegistry_ElementNameMustBeDefined);
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(Messages.LanguageRegistry_AttributeNameMustBeDefined);
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException(Messages.LanguageRegistry_AttributeValueMustBeDefined);
        }
        return "[" + elementName.toLowerCase() + "]" + attributeName.toLowerCase() + "=" + attributeValue;
    }
}

