/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preferences;

import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.preferences.Messages;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class FoldingPreferencePage
extends com.aptana.ide.editors.preferences.FoldingPreferencePage {
    private Table foldingTable;
    private Group nodeGroup;
    private Composite buttons;
    private Button add;
    private Button remove;

    protected Control createContents(Composite parent) {
        Composite displayArea = (Composite)super.createContents(parent);
        this.nodeGroup = new Group(displayArea, 0);
        GridLayout groupLayout = new GridLayout(1, true);
        this.nodeGroup.setLayout((Layout)groupLayout);
        this.nodeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nodeGroup.setText(Messages.FoldingPreferencePage_FoldableHTMLNodes);
        this.buttons = new Composite((Composite)this.nodeGroup, 0);
        GridLayout buttonsLayout = new GridLayout(2, true);
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 0;
        this.buttons.setLayout((Layout)buttonsLayout);
        this.add = new Button(this.buttons, 8);
        this.add.setImage(HTMLPlugin.getImage("icons/add_obj.gif"));
        this.add.setToolTipText(Messages.FoldingPreferencePage_Add_One_Or_Mode_Tooltip);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(FoldingPreferencePage.this.getShell(), Messages.FoldingPreferencePage_AddFoldableNodes, Messages.FoldingPreferencePage_AddFoldableNodesDesc, null, null);
                int rc = dialog.open();
                if (rc == 0) {
                    String newNodes = dialog.getValue();
                    String[] nodes = newNodes.split(",");
                    ArrayList<String> nodeList = new ArrayList<String>();
                    int i = 0;
                    while (i < nodes.length) {
                        String trimmed = nodes[i].trim();
                        if (trimmed.length() > 0) {
                            nodeList.add(trimmed);
                        }
                        ++i;
                    }
                    TableItem[] items = FoldingPreferencePage.this.foldingTable.getItems();
                    int i2 = 0;
                    while (items != null && i2 < items.length) {
                        if (!nodeList.contains(items[i2].getText())) {
                            nodeList.add(items[i2].getText());
                        }
                        ++i2;
                    }
                    Collections.sort(nodeList);
                    FoldingPreferencePage.this.foldingTable.removeAll();
                    i2 = 0;
                    while (i2 < nodeList.size()) {
                        TableItem item = new TableItem(FoldingPreferencePage.this.foldingTable, 16384);
                        item.setText((String)nodeList.get(i2));
                        item.setImage(HTMLPlugin.getImage("icons/element_icon.gif"));
                        ++i2;
                    }
                }
            }
        });
        this.remove = new Button(this.buttons, 8);
        this.remove.setImage(HTMLPlugin.getImage("icons/delete_obj.gif"));
        this.remove.setToolTipText(Messages.FoldingPreferencePage_RemoveSelectedNode);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = FoldingPreferencePage.this.foldingTable.getSelection();
                int[] indices = FoldingPreferencePage.this.foldingTable.getSelectionIndices();
                if (items != null) {
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    if (indices.length > 1) {
                        int last = indices[indices.length - 1];
                        if (FoldingPreferencePage.this.foldingTable.getItemCount() - 1 >= last) {
                            FoldingPreferencePage.this.foldingTable.setSelection(last);
                        } else if (FoldingPreferencePage.this.foldingTable.getItemCount() > 0) {
                            FoldingPreferencePage.this.foldingTable.setSelection(FoldingPreferencePage.this.foldingTable.getItemCount() - 1);
                        }
                    } else if (indices.length == 1) {
                        if (FoldingPreferencePage.this.foldingTable.getItemCount() - 1 >= indices[0]) {
                            FoldingPreferencePage.this.foldingTable.setSelection(indices[0]);
                        } else if (FoldingPreferencePage.this.foldingTable.getItemCount() > 0) {
                            FoldingPreferencePage.this.foldingTable.setSelection(FoldingPreferencePage.this.foldingTable.getItemCount() - 1);
                        }
                    }
                }
                FoldingPreferencePage.this.remove.setEnabled(FoldingPreferencePage.this.foldingTable.getSelectionCount() > 0);
            }
        });
        this.buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        this.foldingTable = new Table((Composite)this.nodeGroup, 2818);
        this.foldingTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.foldingTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FoldingPreferencePage.this.remove.setEnabled(true);
            }
        });
        String foldedNodeList = HTMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editors.FOLDING_HTML_NODE_LIST");
        String[] nodes = foldedNodeList.split(",");
        int i = 0;
        while (i < nodes.length) {
            TableItem item = new TableItem(this.foldingTable, 16384);
            item.setText(nodes[i].trim());
            item.setImage(HTMLPlugin.getImage("icons/element_icon.gif"));
            ++i;
        }
        return displayArea;
    }

    protected void performDefaults() {
        this.foldingTable.removeAll();
        String foldedNodeList = HTMLPlugin.getDefault().getPreferenceStore().getDefaultString("com.aptana.ide.editors.FOLDING_HTML_NODE_LIST");
        String[] nodes = foldedNodeList.split(",");
        int i = 0;
        while (i < nodes.length) {
            TableItem item = new TableItem(this.foldingTable, 16384);
            item.setText(nodes[i].trim());
            item.setImage(HTMLPlugin.getImage("icons/element_icon.gif"));
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        String nodeListPref = "";
        int i = 0;
        while (i < this.foldingTable.getItemCount()) {
            TableItem item = this.foldingTable.getItem(i);
            nodeListPref = String.valueOf(nodeListPref) + item.getText() + ",";
            ++i;
        }
        HTMLPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.editors.FOLDING_HTML_NODE_LIST", nodeListPref);
        return super.performOk();
    }

    public void addInitialFoldingFields() {
    }

    public String getLanguage() {
        return "text/html";
    }

    public IPreferenceStore storeToInitialize() {
        return HTMLPlugin.getDefault().getPreferenceStore();
    }
}

