/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preview;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.editors.unified.ContributedOutline;
import java.io.File;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class DefaultBrowser
extends ContributedBrowser {
    private Browser browser;
    private ContributedOutline outline;
    private ProgressListener listener;
    private String url;

    public void createControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listener = new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                DefaultBrowser.this.progressCompleted(event);
            }
        };
        this.browser.addProgressListener(this.listener);
    }

    private String addCacheBuster(String baseURL) {
        String bustedURL = null;
        if (UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.CACHE_BUST_BROWSERS")) {
            if (baseURL != null) {
                String buster = "APTANA_NOCACHE_" + System.currentTimeMillis() + "=" + System.currentTimeMillis();
                bustedURL = baseURL.indexOf(63) == -1 ? String.valueOf(baseURL) + "?" + buster : String.valueOf(baseURL) + "&" + buster;
            }
        } else {
            bustedURL = baseURL;
        }
        return bustedURL;
    }

    public void setURL(String url) {
        this.url = url;
        if (this.browser != null && !this.browser.isDisposed() && this.url != null) {
            if (!"about:blank".equals(url) && !url.startsWith("file:/")) {
                this.browser.setUrl(this.addCacheBuster(url));
            } else {
                this.browser.setUrl(url);
            }
            if (this.outline != null) {
                this.outline.refresh();
            }
        }
    }

    public Control getControl() {
        return this.browser;
    }

    public void addLocationListener(LocationListener listener) {
        if (this.browser != null) {
            this.browser.addLocationListener(listener);
        }
    }

    public void removeLocationLister(LocationListener listener) {
        if (this.browser != null) {
            this.browser.removeLocationListener(listener);
        }
    }

    public Object getUnderlyingBrowserObject() {
        return this.browser;
    }

    public void refresh() {
        if (this.browser != null && !this.browser.isDisposed() && this.url != null) {
            this.browser.setUrl(this.addCacheBuster(this.url));
        }
    }

    public void dispose() {
        this.browser.dispose();
    }

    public void setOutline(ContributedOutline outline) {
        this.outline = outline;
    }

    public void back() {
        this.browser.back();
    }

    public void forward() {
        this.browser.forward();
    }

    public boolean execute(String script) {
        return this.browser.execute(script);
    }

    public void displaySource() {
        this.browser.execute("window.status='empty'");
        this.browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                if (event.text != null) {
                    try {
                        String newFileName = FileUtils.getRandomFileName((String)"source", (String)".html");
                        File temp = new File(String.valueOf(FileUtils.systemTempDir) + File.separator + newFileName);
                        temp.deleteOnExit();
                        FileUtils.writeStringToFile((String)event.text, (File)temp);
                        IEditorInput input = CoreUIUtils.createJavaFileEditorInput((File)temp);
                        try {
                            IDE.openEditor((IWorkbenchPage)HTMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)"com.aptana.ide.editors.HTMLEditor");
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                DefaultBrowser.this.browser.removeStatusTextListener((StatusTextListener)this);
            }
        });
        this.browser.execute("window.status=document.documentElement.outerHTML.toString()");
    }
}

