/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.html.preview;

import com.aptana.ide.editor.html.HTMLPlugin;
import com.aptana.ide.editor.html.preview.ContributedPreviewPage;
import com.aptana.ide.editor.html.preview.DefaultBrowser;
import com.aptana.ide.editor.html.preview.IBrowserTabAdder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class PreviewTabManager {
    public static final String EXTENSION_NAME = "browserTabs";
    public static final String EXTENSION_POINT = String.valueOf(HTMLPlugin.ID) + "." + "browserTabs";
    public static final String TAB_ELEMENT = "tab";
    public static final String STATIC_ELEMENT = "static";
    public static final String URL_ELEMENT = "url";
    public static final String NAME_ELEMENT = "name";
    public static final String CLASS_ATTRIBUTE = "class";
    private static PreviewTabManager manager;
    private List<IBrowserTabAdder> adders = new ArrayList<IBrowserTabAdder>();
    private List<ContributedPreviewPage> staticTabs = new ArrayList<ContributedPreviewPage>();

    private PreviewTabManager() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            IConfigurationElement element = iConfigurationElementArray[n];
            if (TAB_ELEMENT.equals(element.getName())) {
                String className = element.getAttribute(CLASS_ATTRIBUTE);
                if (className != null) {
                    try {
                        Object client = element.createExecutableExtension(CLASS_ATTRIBUTE);
                        if (client instanceof IBrowserTabAdder) {
                            this.adders.add((IBrowserTabAdder)client);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            } else if (STATIC_ELEMENT.equals(element.getName())) {
                String url = element.getAttribute(URL_ELEMENT);
                String name = element.getAttribute(NAME_ELEMENT);
                if (url != null && name != null) {
                    ContributedPreviewPage page = new ContributedPreviewPage(null);
                    page.setBrowser(new DefaultBrowser(), "Default");
                    page.setTitle(name);
                    page.setValue(url);
                    this.staticTabs.add(page);
                }
            }
            ++n;
        }
    }

    public IBrowserTabAdder[] getTabAdders() {
        return this.adders.toArray(new IBrowserTabAdder[0]);
    }

    public ContributedPreviewPage[] getStaticTabs() {
        return this.staticTabs.toArray(new ContributedPreviewPage[0]);
    }

    public static PreviewTabManager getManager() {
        if (manager == null) {
            manager = new PreviewTabManager();
        }
        return manager;
    }
}

