/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.wizards;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.documentation.DocumentationPlugin;
import com.aptana.ide.librarymanager.LibraryInfo;
import com.aptana.ide.librarymanager.LibraryManager;
import com.aptana.ide.wizards.LibraryWizardPage;
import com.aptana.ide.wizards.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class LibraryProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private IProject newProject;
    private WizardNewProjectCreationPage mainPage;
    private WizardNewProjectReferencePage referencePage;
    private LibraryWizardPage libPage;
    private IConfigurationElement configElement;
    private static String WINDOW_PROBLEMS_TITLE = ResourceMessages.NewProject_errorOpeningWindow;
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    private static final String PREFERRED_PERSPECTIVES = "preferredPerspectives";

    public LibraryProjectWizard() {
        IDialogSettings workbenchSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("BasicNewProjectResourceWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(section);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle(ResourceMessages.NewProject_title);
        this.mainPage.setDescription(ResourceMessages.NewProject_description);
        this.mainPage.setPageComplete(false);
        this.addPage((IWizardPage)this.mainPage);
        IStructuredContentProvider provider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return LibraryManager.getInstance().getLibraryInfoExtensions();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        ILabelProvider labelProvider = new ILabelProvider(){

            public Image getImage(Object element) {
                String iconFile;
                Image result = null;
                if (element instanceof LibraryInfo && (iconFile = ((LibraryInfo)element).getIconFile()) != null && iconFile.length() > 0) {
                    File file = new File(iconFile);
                    result = new Image((Device)Display.getDefault(), file.getAbsolutePath());
                }
                return result;
            }

            public String getText(Object element) {
                return element.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        this.libPage = new LibraryWizardPage(Messages.LibraryProjectWizard_JavaScriptLibraries, provider, labelProvider);
        this.libPage.setTitle(Messages.LibraryProjectWizard_ImportJavaScriptLibrary);
        this.libPage.setDescription(Messages.LibraryProjectWizard_ImportJavaScriptLibraryIntoProject);
        this.libPage.setPageComplete(false);
        this.addPage((IWizardPage)this.libPage);
    }

    private IProject createNewProject() {
        IProject[] refProjects;
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        if (this.referencePage != null && (refProjects = this.referencePage.getReferencedProjects()).length > 0) {
            description.setReferencedProjects(refProjects);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                if (monitor != null) {
                    monitor.beginTask(Messages.LibraryProjectWizard_CreatingProject, 1);
                }
                LibraryProjectWizard.this.createProject(description, newProjectHandle, monitor);
                if (monitor != null) {
                    monitor.worked(1);
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.ide", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)t.getMessage()));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(ResourceMessages.NewProject_windowTitle);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = DocumentationPlugin.getImageDescriptor("icons/newprj_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    private static void openInNewWindow(IPerspectiveDescriptor desc) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(desc.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) break block2;
                ErrorDialog.openError((Shell)window.getShell(), (String)WINDOW_PROBLEMS_TITLE, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    public boolean performFinish() {
        final IProject p = this.createNewProject();
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    LibraryProjectWizard.this.createProject(p, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected void createProject(IProject p, IProgressMonitor monitor) {
        String path;
        IWorkspaceRoot workspaceRoot;
        IResource resource;
        String fileToOpen = LibraryProjectWizard.copyLibraryFiles(monitor, p, this.libPage.getSelectedLibraries());
        if (this.newProject == null) {
            return;
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        if (fileToOpen != null && (resource = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).findMember(String.valueOf(path = p.getFullPath().toPortableString()) + "/" + fileToOpen)) != null && resource instanceof IFile) {
            LibraryProjectWizard.openFileInEditor((IFile)resource);
        }
    }

    private static void openFileInEditor(IFile f) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.getEditorDescriptor((String)f.getName());
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.LibraryProjectWizard_ErrorGettingEditorDescriptor, (Throwable)e);
        }
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)f, (boolean)true);
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.LibraryProjectWizard_ErrorOpeningEditor, (Throwable)e);
        }
    }

    public static String copyLibraryFiles(IProgressMonitor monitor, IProject p, String[] selection) {
        String toOpen = null;
        int j = 0;
        while (j < selection.length) {
            String destinationDir = p.getLocation().toOSString();
            String sourceDir = selection[j];
            try {
                try {
                    File f = new File(sourceDir);
                    File[] files = f.listFiles();
                    if (monitor != null) {
                        monitor.beginTask(StringUtils.format((String)Messages.LibraryProjectWizard_CopyingFiles, (String)selection[j]), files.length);
                    }
                    int i = 0;
                    while (i < files.length) {
                        String name = files[i].getName();
                        if (monitor != null) {
                            monitor.subTask(name);
                        }
                        FileUtils.copy((String)sourceDir, (String)destinationDir, (String)name);
                        if (toOpen == null && (name.toLowerCase().endsWith(".htm") || name.toLowerCase().endsWith(".html"))) {
                            toOpen = name;
                        }
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)DocumentationPlugin.getDefault(), (String)Messages.LibraryProjectWizard_UnableToCopyFileToProject, (Throwable)e);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
            try {
                p.refreshLocal(2, null);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)DocumentationPlugin.getDefault(), (String)Messages.LibraryProjectWizard_Error, (Throwable)e);
            }
            ++j;
        }
        return toOpen;
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    protected void updatePerspective() {
        LibraryProjectWizard.updatePerspective(this.configElement);
    }

    public static void updatePerspective(IConfigurationElement configElement) {
        int workbenchPerspectiveSetting;
        IWorkbenchWindow window;
        if (configElement == null) {
            return;
        }
        String perspSetting = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String promptSetting = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!promptSetting.equals("prompt") && perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        String finalPerspId = configElement.getAttribute(FINAL_PERSPECTIVE);
        if (finalPerspId == null) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            IDEWorkbenchPlugin.log((String)("Unable to find persective " + finalPerspId + " in BasicNewProjectResourceWizard.updatePerspective"));
            return;
        }
        ArrayList preferredPerspIds = new ArrayList();
        LibraryProjectWizard.addPerspectiveAndDescendants(preferredPerspIds, finalPerspId);
        String preferred = configElement.getAttribute(PREFERRED_PERSPECTIVES);
        if (preferred != null) {
            StringTokenizer tok = new StringTokenizer(preferred, " \t\n\r\f,");
            while (tok.hasMoreTokens()) {
                LibraryProjectWizard.addPerspectiveAndDescendants(preferredPerspIds, tok.nextToken());
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (currentPersp = page.getPerspective()) != null && preferredPerspIds.contains(currentPersp.getId())) {
                return;
            }
            if (!LibraryProjectWizard.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        if ((workbenchPerspectiveSetting = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("OPEN_PERSPECTIVE_MODE")) == 2) {
            LibraryProjectWizard.openInNewWindow(finalPersp);
            return;
        }
        LibraryProjectWizard.replaceCurrentPerspective(finalPersp);
    }

    private static void addPerspectiveAndDescendants(List perspectiveIds, String id) {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] perspectives = registry.getPerspectives();
        int i = 0;
        while (i < perspectives.length) {
            PerspectiveDescriptor descriptor = (PerspectiveDescriptor)perspectives[i];
            if (descriptor.getOriginalId().equals(id)) {
                perspectiveIds.add(descriptor.getId());
            }
            ++i;
        }
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()), null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }
}

